/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Viewport.h>
#include "FileNom.h"
#include "xt_macro.h"
#include "XmgFileGet.h"

extern Widget			toplevel;
extern XtAppContext		app_context;

Widget				xmg_filenom_shell = NULL;
Widget				xmg_filenom = NULL;
char				*xmg_filename;
t_boolean			xmg_ok;
t_boolean			xmg_check_existence = FALSE;

VOID_FUNC			XmgFileGetSelectCallback(w,data,cbs)
Widget				w;
XtPointer			data;
FileNominatorStruct		*cbs;
{
  static char			path[MAXPATHLEN + 1];
  t_status			status;
  char				*fname;

  if (xmg_check_existence)
    if (cbs->filenameStatus & FileNominatorNonexistent)
      return ;
  XtPopdown(xmg_filenom_shell);
  path[0] = 0;
  if ((status = str_cat_str(path,
			    sizeof (path),
			    cbs->directoryPart)) < 0)
    {
      XmgErrPrint(-status,"str_cat_str");
      return ;
    }
  if ((status = str_cat_str(path,
			    sizeof (path),
			    cbs->filenamePart)) < 0)
    {
      XmgErrPrint(-status,"str_cat_str");
      return ;
    }
  xmg_filename = path;
  xmg_ok = TRUE;
} 

VOID_FUNC			XmgFileGetCancelCallback(w,data,cbs)
Widget				w;
XtPointer			data;
XtPointer			cbs;
{
  XtPopdown(xmg_filenom_shell);
  xmg_ok = TRUE;
}

/* gets a file name from a file selector shell.
   
   Warning: the widget is created during the first call of this
   function and is never recreated, just popdowned. */
char				*XmgFileGet(pattern,check_existence)
char				*pattern;		/* Regexp */
t_boolean			check_existence; /* The file must exist
						    to be accepted */
{
  if (!xmg_filenom_shell)
    {
      INTERFACE(toplevel,
		GETCHILDSHELL(xmg_filenom_shell)
		("xmgFileGetShell",transientShellWidgetClass,
		 XtNmappedWhenManaged,	False,
		 XtNtransientFor,	toplevel,
		 XtNallowShellResize,	True,
		 GETCHILD(xmg_filenom)
		 ("axeFileNominator",fileNominatorWidgetClass,
		  CALLBACK(XtNselectCallback,
			   XmgFileGetSelectCallback,
			   NULL),
		  CALLBACK(XtNcancelCallback,
			   XmgFileGetCancelCallback,
			   NULL),
		  END),
		 MANAGE,
		 END),
		ENDINTERFACE);
      XmgCenterWidget(xmg_filenom_shell);
    }
  XtVaSetValues(xmg_filenom,
		XtNfilter,		pattern,
		NULL);
  xmg_check_existence = check_existence;
  xmg_filename = NULL;
  xmg_ok = FALSE;
  XtPopup(xmg_filenom_shell,XtGrabExclusive);
  while (!xmg_ok)
    {
      XEvent		event;

      XtAppNextEvent(app_context,&event);
      XtDispatchEvent(&event);
    }
  return (xmg_filename);
}
