/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "XmgMessage.h"
#include "a.h"

extern Widget	toplevel;

/* popups an autonomous error message box.
   This is the X version of err_print(3).
   It calls XmgShowMessageBoxFmtVa(3) */
#ifdef HAVE_STDARG_H
VOID_FUNC	XmgErrPrint(int errcode,char *fmt,...)
#else
VOID_FUNC	XmgErrPrint(errcode,fmt,va_alist)
t_status	errcode;
char		*fmt;
va_dcl
#endif
{
  va_list	ap;
  char		buf[BUFSIZ];
  
  assert(errcode >= 0);
  assert(fmt);
#ifdef HAVE_STDARG_H
  va_start(ap,fmt);
#else
  va_start(ap);
  va_arg(ap,int);
  va_arg(ap,char *);
#endif
  vsnprintf(buf,sizeof (buf),fmt,ap);
  if (ERR_SYS(errcode))
    XmgShowMessageBoxFmtVa(toplevel,
			   "%s: %s: %s",
			   buf,
			   err_msg(errcode),
			   strerror(errno));
  else
    XmgShowMessageBoxFmtVa(toplevel,
			   "%s: %s",
			   buf,
			   err_msg(errcode));
  va_end(ap);
}

