/* ************************************************************************* *
   xfsm - (C) Copyright 1993-1997 Robert Gasch (Robert_Gasch@peoplesoft.com)
	  http://www.peoplesoft.com/peoplepages/g/robert_gasch/index.htm

   Permission to use, copy, modify and distribute this software for any 
   purpose and without fee is hereby granted, provided that this copyright
   notice appear in all copies as well as supporting documentation. All
   work developed as a consequence of the use of this program should duly
   acknowledge such use.

   No representations are made about the suitability of this software for
   any purpose. This software is provided "as is" without express or implied 
   warranty.

   See the GNU General Public Licence for more information.
 * ************************************************************************* */


/* ****** include files ****** */
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Xresource.h>
#ifndef DYNIX
# include <stdlib.h>
#endif
#ifdef __STDC__
# include <stdarg.h>
#else
# include <varargs.h>
#endif
#include <stdio.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/stat.h>
/* ******************************************************************* */
/* *** This may seem an odd way of handling porting exceptions but *** */
/* *** it concentrates most changes right here and results in code *** */
/* *** which is much more legible and mainainable than if I had to *** */
/* ***   #ifdef all these into util.c. After almost 10 different   *** */
/* ***    systems were supported legibility started to become a    *** */
/* ***              problem so I opted for this approach.          *** */
/* ******************************************************************* */
#if defined (SUNOS) || defined (LINUX) || defined (HPUX) || \
    defined (CONVEXOS) || defined (MACH) || defined (AUX)
#include <sys/vfs.h>
#include <mntent.h>
#define fs_ignore	MNTTYPE_IGNORE		/* ignore FS flag */
# else
# if defined (SVR4) || defined (SOLARIS) || defined (DGUX)
# include <sys/statvfs.h>
# include <sys/mnttab.h>
# include <sys/mntent.h>
# define statfs		statvfs			/* FS stats structure */
#  if defined (SVR4) || defined (SOLARIS)
#   define mntent	mnttab			/* mount structure */
#   define mnt_fsname	mnt_special		/* device name */
#   define mnt_dir	mnt_mountp		/* mount point */
#   define mnt_type	mnt_fstype		/* mount type */
#   define mnt_opts	mnt_mntopts		/* mount option */
#   define f_bsize	f_frsize		/* block size */
#    ifdef SOLARIS
#     define fs_ignore    MNTOPT_IGNORE		/* ignore FS flag */
#    else  
#     define fs_ignore	MNTTYPE_IGNORE		/* ignore FS flag */
#    endif /* SOLARIS */
#  endif /* SVR4 || SOLARIS */
#  if defined (DGUX)
#   include <mntent.h>
#   define fs_ignore    "ignore"                /* ignore FS flag */
#  endif /* DGUX */
#  else
#   ifdef DYNIX
#    include <mntent.h>
#    include <sys/vfs.h>
#    include <sys/select.h>
#    include <sys/statfs.h>
#    define fs_ignore	MNTTYPE_IGNORE	 	/* ignore FS flag */ 
#   else
#    ifdef AIX
#     include <sys/statfs.h>
#     include <sys/select.h>			/* required for msleep */
#     include <sys/mntctl.h>
#     include <sys/vmount.h>
#     include <fstab.h>
#     define mntent	vmount			/* mount structure */
#     define BUFFERSIZE	128*1024		/* 128 Kb */
#    else
#     ifdef OSF1
#      include <sys/mount.h>
#      define f_bsize	f_fsize			/* block size */
#      define fs_ignore	"xx"			/* ignore FS flag */
#     else
#     ifdef ULTRIX
#      include <sys/param.h>
#      include <sys/mount.h>
#      define GT_UNKWN	0		/* Taken from <sys/fs_types.h> */
#      define mntent	fs_data			/* FS stucture for getmnt */
#      define statfs	fs_data			/* FS stats structure */
#      define mnt_dir	fd_req.path		/* mount path */
#      define mnt_fsname fd_req.devname		/* device name */
#      define mnt_opts	fd_req.flags		/* mount options */
#      define mnt_type	fd_req.fstype		/* mount type */
#      define f_bsize 	fd_req.bsize		/* block size */
#      define f_blocks 	fd_req.btot		/* number of blocks */
#      define f_bfree  	fd_req.bfree		/* free blocks */
#      define f_bavail 	fd_req.bfreen		/* available blocks */
#      define f_files 	fd_req.gtot		/* number of inodes (gnodes) */
#      define f_ffree 	fd_req.gfree		/* free indodes (gnodes) */
#      define fs_ignore	GT_UNKWN		/* ignore FS flag */
#      else
#       ifdef SCO
#        include <sys/statfs.h> 
#        define MAXPATHLEN 1024
#	else
#	 if defined (FreeBSD) || defined (BSDI)
# 	  include <sys/mount.h>
#          ifdef SGI
#	    include <sys/statvfs.h>
#	    include <mntent.h>
#	    define statfs	statvfs
#           define fs_ignore	MNTTYPE_IGNORE	/* ignore FS flag */
#          endif /* SGI */
#	 endif /* Free BSD */
#      endif /* SCO */
#     endif /* ULTRIX */
#    endif /* OSF1 */
#   endif /* AIX */
#  endif /* DYNIX */
# endif /* SVR4 || SOLARIS || DGUX */
#endif /* SUNOS || LINUX || HPUX || CONVEXOS || MACH || AUX */


/* ******************************************************************* */
/* *** specify which file we can check to see if the mounted file  *** */
/* *** system information has been updated. This is not available  *** */
/* *** on all systems though (AIX, Ultrix and OSF/1 keep this info *** */
/* ***                     in a binary database)                   *** */
/* ******************************************************************* */
#if defined (SUNOS) || defined (LINUX) || defined (DYNIX) || \
    defined (CONVEXOS) || defined (AUX) || defined (SGI)
#define MOUNT_FILE	"/etc/mtab"
# else 
# if defined (SVR4) || defined (HPUX) || defined (MACH) || \
     defined (SOLARIS) || defined (SCO) || defined (DGUX)
# define MOUNT_FILE	"/etc/mnttab"
# endif /* SVR4 || HPUX || MACH || SOLARIS || SCO || DGUX */
#endif /* SUNOS || LINUX || DYNIX || CONVEXOS || AUX */


/* ********************************************************************** */
/* *** We use DETAIL_NUM to calculate the height of the detail window *** */
/* ********************************************************************** */
#if defined (SVR4) || defined (SOLARIS) || defined (SGI) || defined (DGUX)
#define DETAIL_NUM	13
#else
# if defined (SUNOS) || defined (LINUX) || defined (HPUX) || \
     defined (ULTRIX) || defined (CONVEXOS) || defined (AIX) || \
     defined (DYNIX) || defined (FreeBSD) || defined (AUX) || defined(BSDI)
# define DETAIL_NUM	12
#  else
#  ifdef OSF1
#  define DETAIL_NUM	10
#   else
#   ifdef SCO
#    define DETAIL_NUM	9
#   endif /* SCO */
#  endif /* OSF1 */
# endif /* SUNOS || LINUX || HPUX || ULTRIX || MACH || CONVEXOS || AIX || \
           DYNIX || FreeBSD || AUX || BSDI */
#endif /* SVR4 || SOLARIS || SGI || DGUX */



/* ******************************************************************** */
/* ******************** general program constants ********************* */
/* ******************************************************************** */
#define TRUE		1
#define FALSE		0
#define	STRLENGTH	255		/* length of a string */
#define NOGOOD		-1		/* to distinguish nogood from false */
#define MAXFS           50		/* maximum number of file systems */
#define QUIT_KEY	'q'		/* quit key */
#define UPDATE_KEY	'u'		/* update key */
#define TOGGLE_KEY	't'		/* toggle mode key */
#define CLOSE_KEY	'c'		/* close detailed window key */
#define MB		1048576		/* 1Mb = 1048576 Bytes */
#define GB		1073741824	/* 1Gb = 1073741824 Bytes */
#define MINIMIZE	1		/* minimize */
#define MNL		2		/* minimize with regard to FS name */
#define CLASS_NAME	"Xfsm"		/* How do we look for resources */
#define DEFAULT_FONT	"6x13"		/* default font */

#ifdef LINUX
# define RES_SPACE_DFLT	5		/* reserved space; ext2 = 5% */
#else
# define RES_SPACE_DFLT	10		/* reserved space; default = 10% */
#endif

	/* macros used to access the strings through the use of the index */
#define FsName		strinfo[idx[i]].fs_name
#define DevName		strinfo[idx[i]].dev_name
#define MntTyp		strinfo[idx[i]].mnt_typ
#define	MntOpt		strinfo[idx[i]].mnt_opt

					/* mabe the largest has changed */
#define HAS_BIGGEST_CHANGED \
		o_b_disk!=b_disk || o_b_blocks!=b_blocks || o_b_bsize!=b_bsize

#ifndef APP_DEFAULTS_DIR
#define APP_DEFAULTS_DIR        "/usr/X11R5/lib/X11/app-defaults/"
#endif

					/* If something is not available we */
					/* use this to copy NA into the sting */
#define CHECKNA		if (! strcmp (s, "-1")) strcpy (s, "N.A.")
#define PRINT_KNOWN_BUGS printf ("\n")	/* at this point there are none */

					/* well, I did write the damn thing */
#define PRINT_COPYRIGHT		printf ("\
xfsm v1.97 - (C) Copyright 1993-1997 Robert Gasch (Robert_Gasch@peoplesoft.com)\n\
	     http://www.peoplesoft.com/peoplepages/g/robert_gasch/index.htm\n")


/* ****** define window constants - these are positions and sizes ****** */
#define DEF_BORDER_WIDTH 	4 /* Default border width. */
#define WIN_X 			150
#define WIN_Y 			150
#define MIN_WIN_X		100
#define MENU_HEIGHT(w) 		(LETTER_HEIGHT(w))
#define MIN_MENU_HEIGHT		4
#define LETTER_HEIGHT(w)  	((w).font_info->ascent + (w).font_info->descent)
#define LETTER_ASCENT(w)  	((w).font_info->ascent)
#define LETTER_SPACE(w)	  	(LETTER_HEIGHT(w) + 5 )
#define FREE_LETTER_SP(w) 	(LETTER_SPACE(w)-LETTER_HEIGHT(w))
#define NFS_TEXT_Y 		(fs_win[i].y-(LETTER_SPACE(fs_win[i])-\
				(LETTER_HEIGHT(fs_win[i])+1)))
#define SM_MENU_WIDTH(w) 	(XTextWidth((w).font_info, (w).text, \
				strlen((w).text)))
#define MENU_ITEMS		2
#define MENU_SPACE(w)		(MENU_HEIGHT(w)*(MENU_ITEMS+2))
#define BEGIN_NFS(w)		MENU_SPACE(w)
#define MENU_Y			10
#define OFF_X			10
#define OFF_Y			10
#define INTERVAL(w)		((MENU_HEIGHT(w)+FREE_LETTER_SP(w))*2) 
#define	MIN_INTERVAL(w)		(MIN_MENU_HEIGHT+FREE_LETTER_SP(w)+\
				MENU_HEIGHT(w))
#define DETAIL_LETTER_X		13
#define DETAIL_LETTER_STRING	"XXXXXXXXXXXX "
#define DETAIL_X		(OFF_X*2 + XTextWidth(detail_win.font_info,\
 				"Blocks Available    WWWWWWWWWWW",  \
				sizeof("Blocks Available    WWWWWWWWWWW")))
#define DETAIL_Y		((MENU_HEIGHT(detail_win)*(DETAIL_NUM+3))+\
				(OFF_X*2))
/* ****** define constants used to identify menus and windows(buttons) ****** */
#define UPDATE		0
#define	QUIT		1
/* ******************** define the warning bitmap size ********************** */
#define warn_width 4
#define warn_height 10
#define popup_width 8
#define popup_height 10


/* ******************************************************************** */
/* ********************* program data structures ********************** */
/* ******************************************************************** */

/* *** string to hold file system name *** */
typedef char MyString[STRLENGTH];

/* *** struct to hold all the string info copied form static system areas *** */
typedef struct {
	MyString	fs_name,	/* FS names */
			dev_name,	/* Device Names */
#ifndef SCO
			mnt_typ,	/* type of device mount */
#endif /* !SCO */
			mnt_opt;	/* option of device mount */
		} StringInfo, *StringInfoPtr;

/* ****** XWindow struct - this simplifies function calls ****** */
typedef struct {
	Window 		win;		/* window ID */
	GC		gc;		/* window graphics content */
	XFontStruct*	font_info;	/* Font the window is using. */
	char		text[40];	/* title (for menus) */
	int		x, y, 		/* position */
			width, height, 	/* size */
			line_thick;	/* line thickness of window border */
	unsigned long	fg, bg;		/* foreground and background */
	long		event_mask, 	/* which events will be registered */ 
			flags;		/* window flags */
		} WinType, *WinTypePtr;


/* ******************************************************************** */
/* ********************** function declarations *********************** */
/* ******************************************************************** */

void	do_event_loop(
#if NeedFunctionPrototypes
		      int argc,
		      char** argv
#endif
);
void	handle_NFS_change(
#if NeedFunctionPrototypes
			  int ppnfs,
			  int OFS
#endif
);
void	fix_menu_pos(
#if NeedFunctionPrototypes
		     int width
#endif
);
void	fix_fs_win_width(
#if NeedFunctionPrototypes
			 int i
#endif
);
void	set_fs_win_size(
#if NeedFunctionPrototypes
			int i,
			int ppnfs
#endif
);
void	get_fs(
#if NeedFunctionPrototypes
	       void
#endif
);
void	toggle_mode(
#if NeedFunctionPrototypes
		    void
#endif
);
void	redraw_main_win(
#if NeedFunctionPrototypes
			void
#endif
);
void 	write_detail(
#if NeedFunctionPrototypes
		     int i
#endif
);
void	write_available(
#if NeedFunctionPrototypes
		        int i
#endif
);
void 	write_percent(
#if NeedFunctionPrototypes
		      int i
#endif
);
void 	redraw_fs_win(
#if NeedFunctionPrototypes
		      int i
#endif
);
void	get_fs_stat(
#if NeedFunctionPrototypes
		    void
#endif
);
void	open_detail_win(
#if NeedFunctionPrototypes
		    int	argc,
		    char **argv
#endif
);
void 	create_window (
#if NeedFunctionPrototypes
		       Window parent_win,
		       WinTypePtr this_win,
		       unsigned long foreg,
		       unsigned long backg
#endif
);
int	highlight_menu(
#if NeedFunctionPrototypes
		       WinType menu[],
		       int menu_num,
		       int hightlight
#endif
);
int	expose_win(
#if NeedFunctionPrototypes
		   WinType menu[],
		   int menu_num
#endif
);
void	destroy_menu(
#if NeedFunctionPrototypes
		     WinType menu[],
		     int menu_num
#endif
);
int	which_button_pressed(
#if NeedFunctionPrototypes
			     WinType menu[],
			     int menu_num
#endif
);
void	process_databases(
#if NeedFunctionPrototypes
			  int argc,
			  char** argv,
			  XrmDatabase commandlineDB
#endif
);
void	do_help(
#if NeedFunctionPrototypes
			void
#endif
);
void 	init_all_windows(
#if NeedFunctionPrototypes
			 void
#endif
);
Bool	getBoolResource(
#if NeedFunctionPrototypes
			XrmDatabase db,
			char* str_name,
			char* str_class,
			Bool deflt
#endif
);
int	getIntResource(
#if NeedFunctionPrototypes
		       XrmDatabase db,
		       char* str_name,
		       char* str_class,
		       int deflt
#endif
);
unsigned long getColorResource(
#if NeedFunctionPrototypes
			       XrmDatabase db,
			       char* str_name,
			       char* str_class,
			       unsigned long deflt
#endif
);
XFontStruct* getFontResource(
#if NeedFunctionPrototypes
			     XrmDatabase db,
			     char* str_name,
			     char* str_class,
			     XFontStruct* deflt
#endif
);
char*	catlist(
#if NeedFunctionPrototypes
		char*,
		...
#endif
);

#if defined (DYNIX) || defined (MACH)
char*  strstr(
#if NeedFunctionPrototypes
	      const char*,
	      const char*
#endif
);
#endif

