.TH xcol 1 "4 October 1995" "X Version 11"
.SH NAME
xcol \- display available colors & change color entries in text files
.SH SYNOPSIS
.B xcol
[-options ...]
[\fIfilename\fP]
.SH DESCRIPTION
.I XCol
displays the colors defined in the \fIrgb.txt\fP file of the X server.
The colors are sorted by their names and their RGB values and shown
in a cube in the \fIColorView\fP window.  The positions of colors in
the window represent their RGB values (the upper right front corner is the
zero point; toward the upper rear left corner is more green, toward
the lower right rear corner is more red; and toward the lower left
front corner is more blue).
.PP
Since there usually are
more colors defined in the file than cells in the colormap, entries with
the same name but different RGB values (for different intensities) are
grouped together.
.PP
If a filename is given as a parameter, all occurrences of color names in that
file are shown in an additional \fITextView\fP window. To change the colors,
a text line has to be made active, and then a new color
can be selected in the \fIColorView\fP window. To get a better
impression of the color, a help color (background) can be selected for each
text line. If two lines define a foreground and a background color, an
association can be made and the colors of both lines can be selected together.
.SH "BUTTONS"
In the \fIColorView\fP window:
.RS
.IP left: 8
select color for the active line.
.PD 0
.IP middle: 8
select help color for the active line.
.IP right: 8
warp pointer to color of active line.
.PD
.RE
.PP
In the \fITextView\fP Window:
.RS
.IP left: 8
select line as active line.
.PD 0
.IP middle: 8
toggle reverse-mode or
.IP "" 8
connect/disconnect 2 lines.
.IP right: 8
show line in the textfile.
.PD
.RE
.SH OPTIONS
.TP 8
.B -rv
Color positions are reversed in the cube. Some new colors can become visible
in the area of the very bright colors.
.TP
.BI -b n
The size of color blocks is set to the constant \fIn\fP. By default, it
depends on the size of the \fIColorView\fP window.
.TP
.BI -gran n
The maximum number of associated colors is set to \fIn\fP. By default,
this value 
is 11. (You can see the effect when reaching the "gray" field, where
101 associated entries are possibly available.)
.TP
.BI -dark n
Specify the intensity of the other colors on the screen (i.e. the
colors outside of the \fIxcol\fP windows) to be \fIn\fP percent (default:
50).  For example, specifying ``0'' to this option will completely
black out the rest of the screen, when \fIxcol\fP's colormap is in
effect.  This is useful because it is easier to select colors if the
screen is darkened slightly.
.TP
.B +\fIchar_list\fP
Add the characters in \fIchar_list\fP to the list of ``space''
chararacters.  Color names in the
text file have to occur between two ``space'' characters to be recognized.  By
default, these 
letters are ' ', '\\t', '\\n', ':', and '"'.
.TP
.B -strings
Names of colors in the text file are only recognized when used in a string
(useful for C source code). This means that the list of ``space''
characters is set to '"' only.
.TP
.B -case
All occurrences of color names in the wrong case are replaced by the
color name in the of the \fIrgb.txt\fP file.
.TP
.B -help
Print a usage message.
.TP
.B -file \fIname\fP
name of a different \fIrgb.txt\fP file. It is also possible to
supply a file in the style of the XCMSDB-files. Since these files are not
exactly defined, they are parsed 'as good as possible'.
.SH FILES
/usr/lib/X11/rgb.txt
.SH "SEE ALSO"
X(1)
.SH BUGS
The selection is only copied to CUT_BUFFER0 instead of a complete
implementation of the select mechanism.
.SH COPYRIGHT
Copyright 1990, University of Kaiserslautern.
.PP
Author: Helmut Hoenig (Helmut.Hoenig@hub.de)
.PP
Permission to use, copy, modify, and distribute this
software for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies.
