/* ----------------------------------------------------------------------------
 * Copyright (C) 1995-1999 by Karim Kaschani
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * to rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 
 * --------------------------------------------------------------------------*/

/* ----------------------------------------------------------------------------
 * xlogin.h - main header file
 * --------------------------------------------------------------------------*/

/* ---------------------------------------------------------------- includes */
 
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/utsname.h>
#include <dirent.h>
#include <unistd.h>
#include <sys/wait.h>
#include <signal.h>
 
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/Xfuncs.h>
 
#include <Xm/XmAll.h>
#include <Xm/XmP.h>
 
/* ------------------------------------------------------------------ macros */

#define MAX(a,b)		(a > b) ? a : b

#define MAX_HOSTS		255
#define MAX_CHARS		255
#define MAX_OPTIONS		32
#define MAX_ITEMS		32

#define TRUE			1
#define FALSE			0
#define SUCCESS			1
#define FAIL			0
#define ADD			1
#define DEL			0
#define LOCK			1
#define UNLOCK			0
#define UNDEF			-1
#define AUTOMATIC		0
#define ENABLE			1
#define DISABLE			-1

#define MENU_HELP		200
#define MENU_EXIT		201
#define MENU_REPORT		202
#define MENU_LOG		203
#define MENU_SYNC_LOGFILES	204
#define MENU_SYNC_XHOSTTABLE	205

#define DIALOG_LOGIN		300
#define DIALOG_ADDHOST		301
#define DIALOG_DELHOST		302
#define DIALOG_RELEASE		303
#define DIALOG_LIST		304
#define DIALOG_STARTTEXT	305
#define DIALOG_ENDTEXT		306

#define DIALOG_OK		400
#define DIALOG_CANCEL		401
#define DIALOG_WAIT		402

/* -------------------------------------------------------- global variables */

char		*hostname;			/* name of local host */
Display		*display;			/* local display      */

struct session_type {
	char	*name;
	int	access;
};

struct host_data {
	int	access;				/* server access            */
	int	userreq;			/* user request		    */
	int	sn;				/* number in session table  */
	int	tn;				/* number in terminal table */
	char	*addr;				/* host address             */
	char	*alias;				/* host alias               */
	char	*session;			/* session name             */
	char	*terminal;			/* terminal name            */
	char	*sOptions[MAX_OPTIONS];		/* session options          */
	char	*tOptions[MAX_OPTIONS];		/* terminal options         */
};

struct t_type {
	char	*name[MAX_ITEMS];
	Widget	button[MAX_ITEMS];
};

struct s_type {
	int	access[MAX_ITEMS];
	char	*name[MAX_ITEMS];
	Widget	button[MAX_ITEMS];
};

typedef struct {
	char	*addr;				/* xhost address            */
} XHostData;
