/* ci_libvars.h - C interpreter builtin variables */

/*  Copyright 1992 Mark Russell, University of Kent at Canterbury.
 *
 *  You can do what you like with this source code as long as
 *  you don't try to make money out of it and you include an
 *  unaltered copy of this message (including the copyright).
 */

/* @(#)cx_libvars.h	1.4 21 Apr 1994 (UKC) */

#ifdef WANT_ADDRS
#	define V(var)		(char *)&var
#	define V2(var, name)	(char *)&var
#	define VA(var)		(char *)var
#endif

#ifdef WANT_NAMES
#	ifdef __STDC__
#		define V(var)		#var
#		define V2(var, name)	#name
#		define VA(var)		#var
#	else
#		define V(var)		"var"
#		define V2(var, name)	"name"
#		define VA(var)		"var"
#	endif
#endif

#ifdef BUILTIN_ERRNO
	V(BUILTIN_ERRNO),
#endif

#if !defined (__CLCC__) && defined (__STDC__) && !defined(__GNUC__)
#ifdef BUILTIN_ERRLIST
	V(sys_nerr),
	VA(sys_errlist),
#endif
#endif
	V(optind),
	V(optarg),
	V2(Builtin_environ, environ),
#ifdef BUILTIN_INTERNAL
#ifdef BUILTIN_IOB
	VA(BUILTIN_IOB),
#endif
#ifdef BUILTIN_CTYPE
	VA(BUILTIN_CTYPE),
#endif
#ifdef OS_ULTRIX
	V(_pctype),
#endif
#endif /* BUILTIN_INTERNAL */
#ifdef BUILTIN_X11
	V(_Xdebug)
#endif
