/* ci_libfuncs.h - C interpreter builtin functions */

/*  Copyright 1992 Mark Russell, University of Kent at Canterbury.
 *
 *  You can do what you like with this source code as long as
 *  you don't try to make money out of it and you include an
 *  unaltered copy of this message (including the copyright).
 */

/* @(#)cx_libfuncs.h	1.6 09 Apr 1995 (UKC) */

#ifdef _POSIX_C_SOURCE
#define POSIX
#endif

#undef F
#undef FD
#undef M
#undef F2
#undef FD2

/*
 * One of WANT_ADDRS, WANT_DECLS or WANT_NAMES should be defined before
 * this file is included.
 */

#ifdef WANT_ADDRS
#	define F(typ, func)		(libfunc_addr_t)func,
#	define FD(typ, func)		(libfunc_addr_t)func,
#	define M(typ, func)		(libfunc_addr_t)func,
#	define F2(typ, func, name)	(libfunc_addr_t)func,
#	define FD2(typ, func, name)	(libfunc_addr_t)func,
#endif

#ifdef WANT_DECLS
#	define F(typ, func)
#	define FD(typ, func)		extern typ func();
#	define M(typ, func)
#	define F2(typ, func, name)
#	define FD2(typ, func, name)	extern typ name();
#endif

#ifdef WANT_NAMES
#	ifdef __STDC__
#		define F(typ, func)		#func,
#		define FD(typ, func)		#func,
#		define M(typ, func)		#func,
#		define F2(typ, func, name)	#name,
#		define FD2(typ, func, name)	#name,
#	else
#		define F(typ, func)		"func",
#		define FD(typ, func)		"func",
#		define M(typ, func)		"func",
#		define F2(typ, func, name)	"name",
#		define FD2(typ, func, name)	"name",
#	endif
#endif

#if !defined(OS_BSD44) && !defined(OS_SVR4) && (defined(__GNUC__) || !defined (__STDC__))
	FD(int, fflush)
	FD(int, setbuf)
	FD(int, fprintf)
	FD(int, printf)
	FD(int, fscanf)
	FD(int, scanf)
	FD(int, sscanf)
	FD(int, fgetc)
	FD(int, fputc)
	FD(int, fputs)
	FD(int, puts)
	FD(int, ungetc)
	FD(int, fread)
	FD(int, fwrite)
	FD(int, fseek)
	FD(int, rewind)
	FD(int, perror)
	FD(int, toupper)
	FD(int, tolower)
	FD(int, time)
#endif

#if defined(OS_SVR4) && !defined (__STDC__) && defined (__CLCC__)
	FD(int, toupper)
	FD(int, tolower)
#endif

	/* B1.1 File operations */
	F2(FILE *, builtin_fopen, fopen)
	F2(FILE *, builtin_freopen, freopen)
	F(int, fflush)
	F2(int, builtin_fclose, fclose)
#ifdef NOTYET
	F(int, remove)
#endif
	F(int, rename)
#ifdef NOTYET
	F(int, tmpfile)
#endif
	F(char *, tmpnam)
#ifdef NOTYET
	F(int, setvbuf)
#endif
	F(void, setbuf)

	/* B1.2 Formatted output */
	F(int, fprintf)
	F(int, printf)
	F(int, sprintf)
#ifdef BUILTIN_VPRINTF
	F(int, vfprintf)
	F(int, vsprintf)
#endif

	/* B1.3 Formatted input */
	F(int, fscanf)
	F(int, scanf)
	F(int, sscanf)

	/* B1.4 Character input and output functions */
	F(int, fgetc)
	F(char *, fgets)
	F(int, fputc)
	F(int, fputs)
#ifdef BUILTIN_GETS
	F(char *, gets)
#endif
	F(int, puts)
	F(int, ungetc)

	/* These two are used by most stdio getc/putc macro implementations */
#ifdef BUILTIN_INTERNAL
#ifdef BUILTIN_FLSBUF
	FD(int, BUILTIN_FLSBUF)
#endif
#ifdef BUILTIN_FILBUF
	FD(int, BUILTIN_FILBUF)
#endif
#endif

	/* B1.5 Direct input and output functions */
	F(int, fread)
	F(int, fwrite)

	/* B1.6 File positioning functions */
	F(int, fseek)
	F(int, ftell)
	F(int, rewind)
#ifdef NOTYET
	F(int, fgetpos)
	F(int, fsetpos)
#endif

	/* B1.7 Error functions */
	F(void, perror)

	F2(int, builtin_pclose, pclose)
	F2(int, builtin_popen, popen)

	/* B2 Character class tests */
	M(int, toupper)
	M(int, tolower)

	/* B3 - String and memory functions */
	FD(char *, strcpy)
	FD(char *, strncpy)
	FD(char *, strcat)
	FD(char *, strncat)
	FD(int, strcmp)
	FD(int, strncmp)
	FD(char *, strchr)
	FD(char *, strrchr)
#ifdef NOTYET
	F(int, strspn)
	F(int, strcspn)
	F(int, strpbrk)
	F(int, strstr)
#endif
	FD(size_t, strlen)
#ifdef NOTYET
	F(int, strerror)
#endif
	FD(char *, strtok)
	FD(voidptr, memcpy)
#ifdef NOTYET
	FD(void *, memmove)
#endif
	FD(int, memcmp)
	FD(void *, memchr)
	FD(void *, memset)

	/* B9 Signals */
	F2(int, builtin_signal, signal)
	FD(unsigned int, alarm)
	FD(unsigned int, sleep)

	/* B5 Utility functions */
	FD(double, atof)
	FD(int, atoi)
	FD(long, atol)
	FD(double, strtod)
	FD(long, strtol)
#ifdef NOTYET
	F(int, strtoul)
#endif
#ifdef BUILTIN_NONPOSIX
	FD(void, srandom)
	FD(long, random)
#endif
	FD(int, rand)
	FD(void, srand)
	F2(int, builtin_calloc, calloc)
	F2(int, builtin_malloc, malloc)
	F2(int, builtin_realloc, realloc)
	F2(int, builtin_free, free)
	FD(void, abort)
	F2(int, builtin_exit, exit)
#ifdef NOTYET
	F(int, atexit)
#endif
	FD(int, system)
	FD(char *, getenv)
#ifdef NOTYET
	F(int, bsearch)
#endif
	F2(int, builtin_qsort, qsort)
#ifdef NOTYET
	F(int, labs)
#endif
#ifdef STRUCTRET
	F(int, div)
	F(int, ldiv)
#endif

	/* Directory routines */
	FD(voidptr, opendir)
	FD(voidptr, readdir)
	FD(int, closedir)
#ifndef POSIX
	FD(void, seekdir)
	FD(long, telldir)
#endif

	/* Old (non-ANSI) library routines */
#ifdef BUILTIN_NONPOSIX
#if defined(OS_SVR4) && defined(POSIX)
	FD(void, setlinebuf)
#else
	FD(int, setlinebuf)
#endif
	FD(int, utimes)
#endif
	FD(char *, mktemp)
	F(time_t, time)
#if defined (BUILTIN_NONPOSIX) && !defined(OS_LINUX)
     	FD(char *, getwd)
#endif
	FD(char *, getcwd)
	FD(char *, ctime)
	FD(int, abs)
	FD(FILE *, fdopen)

	/* Authorisation system calls */
	FD(uid_t, getuid)
	FD(uid_t, geteuid)
	FD(uid_t, getgid)
	FD(uid_t, getegid)
#ifdef BUILTIN_NONPOSIX
	FD(int, setreuid)
	FD(int, setregid)
	FD(int, setgroups)
#endif
	FD(int, getgroups)
#ifndef POSIX
	FD(int, setgrent)
#endif
	FD(int, getgrgid)
#ifndef POSIX
	FD(int, setpwent)
	FD(voidptr, getpwent)
#endif
	FD(voidptr, getpwnam)
	FD(voidptr, getpwuid)

	/* Pathname and file descriptor type system calls */
	F2(int, builtin_read, read)
	F2(int, builtin_write, write)
	F2(int, builtin_pipe, pipe)
	F2(int, builtin_lseek, lseek)
	F2(int, builtin_fcntl, fcntl)
	F2(int, builtin_close, close)
	F2(int, builtin_dup, dup)
	F2(int, builtin_dup2, dup2)
#ifdef BUILTIN_NONPOSIX
	FD(int, getdtablesize)
#endif
	F2(int, builtin_fchown, fchown)
	F2(int, builtin_fchmod, fchmod)
#ifdef BUILTIN_FLOCK
	F2(int, builtin_flock, flock)
#endif
	F2(int, builtin_fsync, fsync)
	F2(int, builtin_ftruncate, ftruncate)
	F2(int, builtin_ioctl, ioctl)
#ifndef POSIX
	FD(int, select)
#endif
	F2(int, builtin_open, open)
	F2(int, builtin_creat, creat)
	FD(int, link)
	FD(int, rename)
#ifndef POSIX
#if defined(OS_SUNOS_4) && defined (__CLCC__)
	FD(int, close)
	FD(int, read)
	FD(int, ioctl)
	FD(int, flock)
	FD(int, write)
	FD(int, fchmod)
	FD(int, fchown)
	FD(int, fsync)
	FD(int, ftruncate)
	FD(int, pipe)
	FD(int, lseek)
	FD(int, dup)
	FD(int, dup2)
#if !(defined (OS_SUNOS_4) && defined (__CLCC__) && !defined (__STDC__))
     	FD(int, popen)
#endif
	FD(int, pclose)
#endif
	FD(int, symlink)
	FD(int, readlink)
	FD(int, chroot)
	FD(int, truncate)
	FD(void, sync)
	FD(int, lstat)
#endif
	FD(int, unlink)
	FD(int, chown)
	FD(int, chmod)
	FD(int, mkdir)
	FD(int, rmdir)
	FD(int, access)
	FD(int, chdir)
	F(int, umask)
	FD(int, stat)
	FD2(int, builtin_fstat, fstat)

	/* Process handling system calls */
	FD(pid_t, getpid)
	FD(pid_t, getpgrp)
#ifndef POSIX
	FD(pid_t, setpgrp)
#endif
	FD(pid_t, fork)
	FD2(pid_t, fork, vfork)
#ifdef BUILTIN_NONPOSIX
	FD(int, wait3)
	FD(int, killpg)
	FD(int, getrusage)
#endif
	FD(int, execve)
	FD(int, wait)
	FD(int, kill)
	FD2(void, builtin__exit, _exit)
	FD(int, execl)
	FD(int, execv)
	FD(int, execle)
	FD(int, execlp)
	FD(int, execvp)

	/* Socket system calls */
#ifdef BUILTIN_BSDSOCKET
	FD(long, send)
	FD(long, sendto)
	FD(long, sendmsg)
	FD(long, recv)
	FD(long, recvfrom)
	FD(long, recvmsg)
	FD(int, socket)
	FD(int, socketpair)
	FD(int, shutdown)
	FD(int, getsockopt)
	FD(int, setsockopt)
	FD(int, getsockname)
	FD(int, bind)
	FD(int, connect)
	FD(int, listen)
	FD(int, accept)
	FD(int, getpeername)
#endif

#ifdef OS_LINUX
	FD(int, gettimeofday)
	FD(int, settimeofday)
	FD(int, adjtime)
#endif

	/* Time system calls */
#ifdef BUILTIN_BSDTIME
	F(int, gettimeofday)
	F(int, settimeofday)
	F(int, adjtime)
#endif
	F(struct tm *, localtime)
	
	/* Miscellaneous library functions */
	FD(int, isatty)
#ifdef BUILTIN_NONPOSIX
	FD(int, ptrace)
	FD(int, putenv)
#endif

	/* BSD signals */
	FD(int, sigaddset)
	FD(int, sigemptyset)
	FD(int, sigprocmask)

	/* netdb.h stuff */
#ifdef BUILTIN_NETLOOKUP
	FD(voidptr, gethostbyname)
	FD(voidptr, gethostbyaddr)
	FD(voidptr, getservbyname)
	FD(voidptr, getservbyport)
#endif

#ifdef BUILTIN_X11
	F(int, XUngrabServer)
	F(int, XUnmapWindow)
	F(int, XGrabServer)
	F(int, XMoveResizeWindow)
	F(int, XDestroyWindow)
	F(int, XrmGetResource)
	F(int, XGetDefault)
	F(int, XrmGetFileDatabase)
	F(int, XStoreColor)
	F(int, XAllocColor)
	F2(int, builtin_XCloseDisplay, XCloseDisplay)
	F(int, XSynchronize)
	F2(int, builtin_XOpenDisplay, XOpenDisplay)
	F(int, XCreateGC)
	F(int, XGetWindowAttributes)
	F(int, XSetStandardProperties)
	F(int, XCreateSimpleWindow)
	F(int, XSetClassHint)
	F(int, XSetWMHints)
	F(int, XParseGeometry)
	F(int, XMapWindow)
	F(int, XChangeWindowAttributes)
	F(int, XBell)
	F(int, XStoreBytes)
	F(int, XSetSelectionOwner)
	F(int, XGetWindowProperty)
	F(int, XFetchBytes)
	F(int, XPending)
	F(int, XConvertSelection)
	F(int, XSendEvent)
	F(int, XChangeProperty)
	F(int, XGetImage)
	F(int, XPutImage)
	F(int, XSetFillStyle)
	F(int, XSetTile)
	F(int, XCreatePixmap)
	F(int, XCopyArea)
	F(int, XSetGraphicsExposures)
	F(int, XDrawLine)
	F(int, XFillRectangle)
	F(int, XLookupKeysym)
	F(int, XLookupString)
	F(int, XPeekEvent)
	F(int, XRaiseWindow)
	F(int, XNextEvent)
	F2(int, builtin_XIfEvent, XIfEvent)
	F(int, XCheckWindowEvent)
	F(int, XWarpPointer)
	F(int, XSync)
	F(int, XFlush)
	F(int, XSelectInput)
	F(int, XLoadQueryFont)
	F(int, XListFonts)
	F(int, XFreeFontNames)
	F(int, XUnloadFont)
	F(int, XDrawImageString)
	F(int, XDrawString)
	F(int, XSetFont)
	F(int, XSetState)
	F(int, XCreateBitmapFromData)
	F(int, XFreePixmap)
	F(int, XCreatePixmapCursor)
	F(int, XFreeCursor)
	F(int, XDefineCursor)
	F(int, XFreeColors)
	F(int, XAllocColorCells)
	F(int, XQueryColor)
	F(int, XParseColor)
	F(int, XStoreColors)
	F(int, XSetBackground)
	F(int, XSetForeground)
	F(int, XDisplayName)
	F(int, XFree)
	F(int, XSetWMProperties)
	F(int, XAllocClassHint)
	F(int, XAllocWMHints)
	F(int, XStringListToTextProperty)
	F(int, XAllocSizeHints)
	F(int, XClearWindow)
	F(int, XDrawRectangle)
	F(int, XTextWidth)
	F(int, XCheckTypedEvent)
	F(int, XClearArea)
#endif

#undef F
#undef FD
#undef M
#undef F2
#undef FD2

