/* ao_ptrace.h - header file for ao_ptrace.c */

/*  Copyright 1995 Mark Russell, University of Kent at Canterbury.
 *
 *  You can do what you like with this source code as long as
 *  you don't try to make money out of it and you include an
 *  unaltered copy of this message (including the copyright).
 */

/* @(#)ao_ptrace.h	1.1 24/5/95 (UKC) */

int ptrace_setreg PROTO((iproc_t *ip, int regno, taddr_t value));
int ptrace_create_child PROTO((target_t *xp,
                               const char **argv, const char **envp, 
                               long rdlist, stopres_t *p_stopres));
int ptrace_attach_to_process PROTO((target_t *xp, int pid));
void ptrace_kill PROTO((target_t *xp));
void ptrace_stop PROTO((target_t *xp));
void ptrace_detach_from_process PROTO((target_t *xp));
stopres_t ptrace_continue PROTO((target_t *xp, taddr_t addr, int sig));
stopres_t ptrace_single_step PROTO((target_t *xp, int sig));
int ptrace_readreg PROTO((iproc_t *ip, int regno, taddr_t *p_val));
int ptrace_read_fpreg PROTO((iproc_t *ip, int regno, int num_bytes, 
                             fpval_t *p_val));
int ptrace_tswap PROTO((iproc_t *ip, taddr_t addr, xp_opcode_t opcode, 
                        xp_opcode_t *p_old_opcode));
sigstate_t ptrace_get_sigstate PROTO((iproc_t *ip, int signo));
int ptrace_read_text_from_process PROTO((iproc_t *ip, taddr_t addr, char *buf, 
                                         size_t nbytes));
int ptrace_read_data PROTO((iproc_t *ip, taddr_t addr, char *buf, 
                            size_t nbytes));
int ptrace_write_data PROTO((iproc_t *ip, taddr_t addr, const char *buf, 
                             size_t nbytes));
int ptrace_write_text PROTO((iproc_t *ip, taddr_t addr, const char *buf, 
                             size_t nbytes));
int ptrace_write_corefile PROTO((iproc_t *ip, const char *name));

#ifdef OS_SUNOS_4
int ptrace_set_all_regs PROTO((iproc_t *ip, sunregs_t *regtab));
void ptrace_get_regtab PROTO((iproc_t *ip, sunregs_t *regtab));
#endif
int ptrace_get_last_attach_pid PROTO((void));
