/* ifdefs.h - #defines of symbols based on predefined macros */

/*  Copyright 1991 Mark Russell, University of Kent at Canterbury.
 *
 *  You can do what you like with this source code as long as
 *  you don't try to make money out of it and you include an
 *  unaltered copy of this message (including the copyright).
 */

/* @(#)ifdefs.h	1.16 25/5/95 (UKC) */

#ifndef IFDEFS_H_INCLUDED
#define IFDEFS_H_INCLUDED

/* ---------------------------------------------------------------------------
 *  This file is now arranged by operating system.  For each OS we then
 *  decide which architecture is being used.
 *
 *  ARCH_SUN3		- Sun 3 (Motorola 68000 based)
 *
 *  ARCH_SPARC		- any SPARC
 *  ARCH_SUN4		- Sun 4 (SPARC)
 *
 *  ARCH_SUN386		- Sun 386i (obsolete)
 *
 *  ARCH_CLIPPER	- Clipper
 *
 *  ARCH_386		- any Intel x86
 *  ARCH_LINUX386	- Linux (x86)
 *  ARCH_BSDI386	- should be BSD/OS (x86), actually any BSD (x86)
 *  ARCH_FREEBSD386	- FreeBSD (x86)
 *
 *  ARCH_MIPS		- any MIPS
 *  ARCH_MIPS_MIPS	- MIPS MIPS
 *  ARCH_ULTRIX_MIPS	- Digital Ultrix MIPS
 *
 *  OS_BSD		- supports most BSD routines
 *  OS_BSD44		- derived from BSD4.4-Lite (not SunOS !)
 *  OS_SVR4		- supports System V release 4 features
 *  OS_SUNOS		- any SunOS
 *  OS_ULTRIX		- Digital Ultrix
 * ---------------------------------------------------------------------------
 */

/* ---------------------------------------------------------------------------
 *  Make pre-processor symbols into a common format.
 * ---------------------------------------------------------------------------
 */

#if defined(bsdi) || defined(__bsdi)
#undef  __bsdi__
#define __bsdi__	1
#endif

#if defined(clipper) || defined(__clipper)
#undef  __clipper__
#define __clipper__	1
#endif

#if defined(i386) || defined(__i386)
#undef  __i386__
#define __i386__	1
#endif

#if defined(mc68000) || defined(__mc68000)
#undef  __mc68000__
#define __mc68000__	1
#endif

#if defined(mc68020) || defined(__mc68020)
#undef  __mc68020__
#define __mc68020__	1
#endif

#if defined(mips) || defined(__mips)
#undef  __mips__
#define __mips__	1
#endif

#if defined(sparc) || defined(__sparc)
#undef  __sparc__
#define __sparc__	1
#endif

#if defined(sun) || defined(__sun)
#undef  __sun__
#define __sun__		1
#endif

#if defined(SVR4) || defined(__SVR4)
#undef  __svr4__
#define __svr4__	1
#endif

#if defined(ultrix) && !defined(__ultrix__)
#undef  __ultrix__
#define __ultrix__	1
#endif

#if defined(vax) && !defined(__vax__)
#undef  __vax__
#define __vax__		1
#endif


/* ---------------------------------------------------------------------------
 *
 * ---------------------------------------------------------------------------
 */

#undef IS_LITTLE_ENDIAN
#undef IS_BIG_ENDIAN


/* ---------------------------------------------------------------------------
 *  Defaults - undefine/redfine later as required
 * ---------------------------------------------------------------------------
 */

/*
 * Supports "long long" and "long double" data types ?
 */
#if (__GNUC__ >= 2)
#define HAVE_LONG_LONG		1
#define HAVE_LONG_DOUBLE	1
#endif

/* (IDE) These do not seem to be used. */
#define SOCKETS			1
#define SYMLINKS		1


/* ---------------------------------------------------------------------------
 *  SunOS 3.x and 4.x
 * ---------------------------------------------------------------------------
 */
#if defined(__sun__) && !defined(__svr4__)

#define OS_BSD			1

#ifdef SUNOS3
#define OS_SUNOS		3
#define OS_SUNOS_3		1
#else
#define OS_SUNOS		4
#define OS_SUNOS_4		1
#endif

/* Obsolete Sun386i systems. */
#if defined(__i386__)
#define ARCH_SUN386	1
#define THIS_ARCH		"sunos-sun386i"
#endif

#if defined(__mc68020__)
#define ARCH_SUN3		1
#define THIS_ARCH		"sunos-sun3"
#define IS_BIG_ENDIAN		1
#endif

#if defined(__sparc__)
#define ARCH_SUN4		1
#define ARCH_SPARC		1
#define THIS_ARCH		"sunos-sparc"
#define IS_BIG_ENDIAN		1
#endif

/* 'acc' has "long long", 'cc' does not. */
#ifndef __STDC__
#undef HAVE_LONG_LONG
#undef HAVE_LONG_DOUBLE
#endif

#endif


/* ---------------------------------------------------------------------------
 *  Solaris 2.x (SunOS 5.x)
 * ---------------------------------------------------------------------------
 */
#if defined(__sun__) && defined(__svr4__)

#define OS_SVR4			1

#define OS_BSD			1
#define OS_SUNOS		5
#define OS_SUNOS_5		1

#define HAVE_LONG_LONG		1
#define HAVE_LONG_DOUBLE	1

#if defined(__sparc__)
#define ARCH_SUN4		1
#define ARCH_SPARC		1
#define THIS_ARCH		"solaris-sparc"
#define IS_BIG_ENDIAN		1
#endif

#if defined(__i386__)
#define ARCH_386		1
#define THIS_ARCH		"solaris-386"
#endif

#endif


/* ---------------------------------------------------------------------------
 *  BSD/OS
 * ---------------------------------------------------------------------------
 */
#if defined(__bsdi__)

#define OS_BSD			1
#define OS_BSD44		1

#if defined(__i386__)
#define ARCH_386		1
#define ARCH_BSDI386	1
#define THIS_ARCH		"bsdi-386"
#endif

#endif


/* ---------------------------------------------------------------------------
 *  Clipper
 * ---------------------------------------------------------------------------
 */
#if defined(__clipper__)

#define OS_BSD			1

#define ARCH_CLIPPER		1
#define THIS_ARCH		"clipper"

#endif


/* ---------------------------------------------------------------------------
 *  FreeBSD
 * ---------------------------------------------------------------------------
 * FreeBSD 2.2.x has started to diverge from other BSDs on Intel x86,
 * ARCH_FREEBSD386 is *only* used to flag these.
 */
#if defined(__FreeBSD__)

#define OS_BSD			1
#define OS_BSD44		1

#if (__FreeBSD__ >= 2)
#include <osreldate.h>
#if	(__FreeBSD_version >= 300000)
#define OS_FREEBSD		3
#elif	(__FreeBSD_version >= 222000)
#define OS_FREEBSD		2
#else
#define OS_FREEBSD		1
#endif
#endif

#if defined(__i386__)

#define ARCH_386		1
#define ARCH_BSDI386  1
#define THIS_ARCH		"bsdi-386"

#if (OS_FREEBSD >= 2)
#define ARCH_FREEBSD386       1
#undef  THIS_ARCH
#define THIS_ARCH		"freebsd-386"
#endif

#endif /* __i386__ */

#endif


/* ---------------------------------------------------------------------------
 *  Linux
 * ---------------------------------------------------------------------------
 */
#if defined(__linux__)

#define OS_LINUX		1
#define OS_BSD			1
#define OS_SVR4			1

#if defined(__i386__)
#define ARCH_386		1
#define ARCH_LINUX386	1
#define THIS_ARCH		"linux-386"
#endif

#endif


/* ---------------------------------------------------------------------------
 *  NetBSD/OpenBSD
 * ---------------------------------------------------------------------------
 * This is an untested guess.
 */
#if defined(__NetBSD__) || defined(__OpenBSD__)

#define OS_BSD			1
#define OS_BSD44		1

#if defined(__i386__)
#define ARCH_386		1
#define ARCH_BSDI386		1
#define THIS_ARCH		"bsd-386"
#endif

#endif


/* ---------------------------------------------------------------------------
 *  MIPS Risc/OS
 * ---------------------------------------------------------------------------
 * The original MIPS running RISC/os, also works for Sony NewsOS.
 * Digital Ultrix ran the processor in 'little endian' mode, see below.
 */
#if defined(__riscos__) || defined(__newsos__)

#define OS_RISCOS		1
#define OS_BSD			1

#if defined(__mips__)
#define ARCH_MIPS		1
#define ARCH_MIPS_MIPS		1
#define THIS_ARCH		"mips-mips"
#define IS_BIG_ENDIAN		1
#endif

#endif


/* ---------------------------------------------------------------------------
 *  Ultrix
 * ---------------------------------------------------------------------------
 */
#if defined(__ultrix__)

#define OS_ULTRIX		1
#define OS_BSD			1

#if defined(__mips__)
#define ARCH_MIPS		1
#define ARCH_ULTRIX_MIPS	1
#define THIS_ARCH		"ultrix-mips"
#endif

#if defined(__vax__)
#define ARCH_VAX	1
#define ARCH_ULTRIX_VAX		1
#define THIS_ARCH		"ultrix-vax"
#endif

#endif

/* ---------------------------------------------------------------------------
 *  something else...
 * ---------------------------------------------------------------------------
 */
#if !defined(THIS_ARCH)

#if defined(bsd)
#define OS_BSD			1
#endif

#if defined(__i386__)
#define ARCH_386		1
#define THIS_ARCH		"unknown-386"
#endif

#if defined(__sparc__)
#define ARCH_SUN4		1
#define ARCH_SPARC		1
#define THIS_ARCH		"unknown-sparc"
#define IS_BIG_ENDIAN		1
#endif

#if defined(__vax__)
#define ARCH_VAX		1
#define THIS_ARCH		"unknown-vax"
#endif

#endif

/* ---------------------------------------------------------------------------
 *  Other features...
 * ---------------------------------------------------------------------------
 */

/*
 * If not big-endian then ...
 */
#if !defined(IS_BIG_ENDIAN)
#define IS_LITTLE_ENDIAN	1
#endif

#endif /* !IFDEFS_H_INCLUDED */
