/* xc_builtins.c - builtin function stubs for the standalone C interpreter */

/*  Copyright 1993 Mark Russell, University of Kent at Canterbury.
 *
 *  You can do what you like with this source code as long as
 *  you don't try to make money out of it and you include an
 *  unaltered copy of this message (including the copyright).
 */

/*
 *  RCB: Rewrote this to #include as few standard header files as
 *  posible, and define as much as possible as extern int foo();
 *  This allows compilation with -ansi.
 */

char ups_xc_builtins_c_sccsid[] = "@(#)xc_builtins.c	1.11 04 Jun 1995 (UKC)";

#define WANT_X11	1	/* builtins for X */

#include <mtrprog/ifdefs.h>

#ifdef _POSIX_SOURCE
#define POSIX
#endif

#include <sys/types.h>
#ifdef OS_LINUX
#include <time.h>
#endif
#include <sys/stat.h>
#include <stdio.h>
#include <fcntl.h>
#include <ctype.h>

#include <errno.h>
#if WANT_X11
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xresource.h>
extern int _Xdebug;
#endif

#include <local/ukcprog.h>

#include "ups.h"
#include "symtab.h"
#include "ci.h"
#include "xc_opcodes.h"
#include "xc_machine.h"
#include "xc_builtins.h"

#ifdef ARCH_CLIPPER
int select();
#endif

#if !defined (OS_SVR4) && defined(THIS_OS)
#define WANT_NONPOSIX
#endif

#if defined (OS_BSD) && !defined (OS_SUNOS_4)
/* Most BSD systems are incorporating POSIX now. */
#undef WANT_NONPOSIX
#endif

/*  BUG: these shouldn't be here.
 */
#ifdef WANT_NONPOSIX
#ifndef __STDC__
int setgrent();
#endif
struct tm *localtime();
int putenv();
int ctime();

#ifdef OS_SUNOS
int ptrace();
#else
int ptrace();
#endif

#ifndef mips
int setlinebuf();
#endif
#endif /* WANT_NONPOSIX */

int isatty();

/* BUG: these probably shouldn't be here
 */
int mktemp();
int getwd();
/*int fdopen(); */

typedef int (*qsort_func_t)PROTO((const void *, const void *));
extern void qsort PROTO((char *base, size_t nel, size_t width,
						qsort_func_t cmp_func));
static void builtin_qsort PROTO((char *base, size_t nel, size_t width,
						textaddr_t cmp_func));
/* extern int XIfEvent PROTO((Display *display, XEvent *xev, 
					textaddr_t wanted_func, char *arg)); */
static int builtin_XIfEvent PROTO((Display *display, XEvent *xev,
					textaddr_t wanted_func, char *arg));
extern textaddr_t signal PROTO((int sig, textaddr_t func));
static textaddr_t builtin_signal PROTO((int sig, textaddr_t func));

extern int _exit PROTO((int status));
static int builtin__exit PROTO((int status));
extern int exit PROTO((int status));
static int builtin_exit PROTO((int status));

/*extern int creat PROTO((const char *path, int mode)); */
static int builtin_creat PROTO((const char *path, int mode));
/*extern int open PROTO((const char *path, int flags, int mode)); */
static int builtin_open PROTO((const char *path, int flags, int mode));
extern int close PROTO((int fd));
static int builtin_close PROTO((int fd));

extern int read PROTO((int fd, void *buf, size_t nbytes));
static int builtin_read PROTO((int fd, void *buf, size_t nbytes));
extern int write PROTO((int fd, const void *buf, size_t nbytes));
static int builtin_write PROTO((int fd, const void *buf, size_t nbytes));
extern int pipe PROTO((int *fds));
static int builtin_pipe PROTO((int *fds));
extern int lseek PROTO((int fd, off_t offset, int whence));
static int builtin_lseek PROTO((int fd, off_t offset, int whence));
/*extern int fcntl PROTO((int fd, int cmd, char *arg));*/
static int builtin_fcntl PROTO((int fd, int cmd, char *arg));
extern int dup2 PROTO((int fd, int newfd));
static int builtin_dup2 PROTO((int fd, int newfd));
extern int dup PROTO((int fd));
static int builtin_dup PROTO((int fd));
extern int fsync PROTO((int fd));
static int builtin_fsync PROTO((int fd));
extern int fchown PROTO((int fd, int uid, int gid));
static int builtin_fchown PROTO((int fd, int uid, int gid));
extern int fchmod PROTO((int fd, mode_t mode));
static int builtin_fchmod PROTO((int fd, int mode));
#ifdef WANT_NONPOSIX
extern int flock PROTO((int fd, int op));
static int builtin_flock PROTO((int fd, int op));
#endif
extern int ftruncate PROTO((int fd, long length));
static int builtin_ftruncate PROTO((int fd, long length));
extern int ioctl PROTO((int fd, unsigned cmd, caddr_t arg));
static int builtin_ioctl PROTO((int fd, unsigned cmd, caddr_t arg));
extern int fstat PROTO((int fd, struct stat *stbuf));
static int builtin_fstat PROTO((int fd, struct stat *stbuf));
extern Display *XOpenDisplay PROTO((const char *display_name));
static Display *builtin_XOpenDisplay PROTO((const char *display_name));
extern int XCloseDisplay PROTO(( Display *dpy));
static int builtin_XCloseDisplay PROTO(( Display *dpy));
extern FILE *fopen PROTO((const char *path, const char *mode));
static FILE *builtin_fopen PROTO((const char *path, const char *mode));
extern int fclose PROTO(( FILE *fp));
static int builtin_fclose PROTO(( FILE *fp));
extern FILE *popen PROTO((const char *cmd, const char *mode));
static FILE *builtin_popen PROTO((const char *cmd, const char *mode));
extern int pclose PROTO(( FILE *fp));
static int builtin_pclose PROTO(( FILE *fp));
extern FILE *freopen PROTO((const char *path, const char *mode,
								FILE *fp));
static FILE *builtin_freopen PROTO((const char *path, const char *mode,
								FILE *fp));

extern voidptr malloc PROTO((size_t size));
static voidptr builtin_malloc PROTO((size_t size));
extern voidptr calloc PROTO((size_t count, size_t size));
static voidptr builtin_calloc PROTO((size_t count, size_t size));
extern voidptr realloc PROTO((voidptr p, size_t size));
static voidptr builtin_realloc PROTO((voidptr p, size_t size));
extern void free PROTO((voidptr p));
static void builtin_free PROTO((voidptr p));

static bool fd_ok PROTO((int fd));

#ifndef __FreeBSD__
#ifdef OS_LINUX
extern const char *const sys_errlist[];
extern int sys_nerr;
#else
extern const char* sys_errlist[];
extern int sys_nerr;
#endif
#endif

extern int optind;
extern char *optarg;

static char **Builtin_environ = NULL;

/*#ifndef __STDC__ */

#ifdef WANT_NONPOSIX
#ifdef OS_ULTRIX
int umask();
#else
void setbuf();
int fread();
int fwrite();
void perror();
#endif
int setpwent();
int tolower(), toupper();
int  srandom();
long random();
#endif /* WANT_NONPOSIX */

extern int strlen();
extern int memcpy();
extern int abort();
extern int strcpy();
extern int strncpy();
extern int strcat();
extern int strncat();
extern int strcmp();
extern int strncmp();
extern int strchr();
extern int strrchr();
extern int strtok();
extern int memchr();
extern int alarm();
extern int sleep();
extern int atof();
extern int atoi();
extern int atol();
extern int strtod();
extern int strtol();
extern int srandom();
extern int rand();
extern int srand();
extern int system();
extern int getenv();
extern int opendir();
extern int readdir();
extern int closedir();
extern int seekdir();
extern int telldir();
extern int utimes();
extern time_t time();
extern int getcwd();
extern int getuid();
extern int geteuid();
extern int getgid();
extern int getegid();
extern int setreuid();
extern int setregid();
extern int setgroups();
extern int getgroups();
extern int setgrent();
extern int getgrgid();
extern int setpwent();
extern int getpwent();
extern int getpwnam();
extern int getpwuid();
extern int getdtablesize();
extern int select();
extern int link();
extern int symlink();
extern int readlink();
extern int chroot();
extern int truncate();
extern int sync();
extern int unlink();
extern int chown();
extern int rmdir();
extern int access();
extern int chdir();
extern int getpid();
extern int getpgrp();
extern int setpgrp();
extern int fork();
extern int wait3();
extern int killpg();
extern int getrusage();
extern int execve();
extern int wait();
extern int kill();
extern int execl();
extern int execv();
extern int execle();
extern int execlp();
extern int execvp();
extern int send();
extern int sendto();
extern int sendmsg();
extern int recv();
extern int recvfrom();
extern int recvmsg();
extern int socket();
extern int socketpair();
extern int shutdown();
extern int getsockopt();
extern int setsockopt();
extern int getsockname();
extern int bind();
extern int connect();
extern int listen();
extern int accept();
extern int getpeername();
extern int gettimeofday();
extern int settimeofday();
extern int adjtime();
extern int sigaddset();
extern int sigemptyset();
extern int sigprocmask();
extern int gethostbyname();
extern int gethostbyaddr();
extern int getservbyname();
extern int getservbyport();

extern void memset PROTO((void*,int,size_t));

int fflush(), fclose(), pclose(), fprintf(), printf(), fscanf(), scanf();
int vsprintf(), vfprintf();
int sscanf(), fgetc(), fputc(), puts(), fputs(), ungetc();
int _flsbuf(), _filbuf(), fseek();
void rewind();
int memcmp();
int utimes(), atoi(), rand(), system(), abs();
int getuid(), geteuid(), getgid(), getegid(), setreuid(), setregid();
int setgroups(), getgroups();
int rename(), read(), write(), pipe(), lseek(), fcntl(), close(), dup(), dup2();
int getdtablesize(), fchown(), flock(), fsync(), ftruncate();
int ioctl(), select(), open(), creat(), link(), unlink(), chown(), chmod();
int mkdir(), symlink(), readlink(), rmdir(), access(), chdir(), chroot();
int truncate(), sync(), stat(), fstat(), lstat(), getpid(), getpgrp();
int setpgrp(), fork(), vfork(), wait3(), killpg(), getrusage();
int execve(), wait(), kill(), _exit(), execl(), execv(), execle(), execlp();
int execvp(), send(), sendto(), sendmsg(), recv(), recvfrom(), recvmsg();
int socket(), socketpair(), getsockopt(), setsockopt(), getsockname();
int bind(), connect(), listen(), getpeername(), gettimeofday();
int settimeofday(), adjtime(), shutdown(), accept();
int alarm(), sleep();
/* #endif  __STDC__*/

#define WANT_ADDRS

static libfunc_addr_t Libfunc_addrs[] = {
#include "cx_libfuncs.h"
};

static char *Libvar_addrs[] = {
#include "cx_libvars.h"
};

#define N_LIBFUNCS	(sizeof Libfunc_addrs / sizeof *Libfunc_addrs)
#define N_LIBVARS	(sizeof Libvar_addrs / sizeof *Libvar_addrs)

static int
builtin__exit(status)
int status;
{
	ci_cause_exit((machine_t *)NULL);
	return status;
}

static int
builtin_exit(status)
int status;
{
	ci_cause_exit((machine_t *)NULL);
	return status;
}

static textaddr_t
builtin_signal(sig, func)
int sig;
textaddr_t func;
{
	return ci_set_sig_handler(sig, func);
}

static void
builtin_qsort(base, nel, width, cmp_func)
char *base;
size_t nel, width;
textaddr_t cmp_func;
{

	qsort(base, nel, width, (qsort_func_t)ci_make_callback(cmp_func, 2));
}

static int
builtin_XIfEvent(display, xev, wanted_func, arg)
Display *display;
XEvent *xev;
textaddr_t wanted_func;
char *arg;
{
	typedef int (*xie_func_t)PROTO((Display *, XEvent *, char *));

	return XIfEvent(display, xev,
			(xie_func_t)ci_make_callback(wanted_func, 3), arg);
}

static bool
fd_ok(fd)
int fd;
{
	if (ci_fd_is_registered((machine_t *)NULL, fd))
		return TRUE;

	errno = EBADF;
	return FALSE;
}

static int
builtin_creat(path, mode)
const char *path;
int mode;
{
	return builtin_open(path, O_WRONLY | O_CREAT | O_TRUNC, mode);
}

static int
builtin_open(path, flags, mode)
const char *path;
int flags, mode;
{
	int fd;

	if ((fd = open(path, flags, mode)) != -1)
		ci_register_fd((machine_t *)NULL, fd);

	return fd;
}

static int
builtin_close(fd)
int fd;
{
	int res;

	if (!fd_ok(fd))
		return -1;

	if ((res = close(fd)) == 0)
		ci_unregister_fd((machine_t *)NULL, fd);

	return res;
}

static int
builtin_read(fd, buf, nbytes)
int fd;
void *buf;
size_t nbytes;
{
	return fd_ok(fd) ? read(fd, buf, nbytes) : -1;
}

static int
builtin_ioctl(fd, cmd, arg)
int fd;
unsigned cmd;
char *arg;
{
	return fd_ok(fd) ? ioctl(fd, (int)cmd, arg) : -1;
}

#ifdef WANT_NONPOSIX
static int
builtin_flock(fd, op)
int fd, op;
{
	return fd_ok(fd) ? flock(fd, op) : -1;
}
#endif

static int
builtin_write(fd, buf, nbytes)
int fd;
constvoidptr buf;
size_t nbytes;
{
	return fd_ok(fd) ? write(fd, buf, nbytes) : -1;
}

static int
builtin_fchmod(fd, mode)
int fd, mode;
{
	return fd_ok(fd) ? fchmod(fd, (mode_t)mode) : -1;
}

static int
builtin_fchown(fd, uid, gid)
int fd, uid, gid;
{
	return fd_ok(fd) ? fchown(fd, uid, gid) : -1;
}

static int
builtin_fstat(fd, st)
int fd;
struct stat *st;
{
	return fd_ok(fd) ? fstat(fd, st) : -1;
}

static int
builtin_fsync(fd)
int fd;
{
	return fd_ok(fd) ? fsync(fd) : -1;
}

static int
builtin_ftruncate(fd, length)
int fd;
long length;
{
	return fd_ok(fd) ? ftruncate(fd, length) : -1;
}

static int
builtin_fcntl(fd, cmd, arg)
int fd, cmd;
char *arg;
{
	int res;

	if (!fd_ok(fd))
		return -1;

	res = fcntl(fd, cmd, arg);

	if (cmd == F_DUPFD && res != -1)
		ci_register_fd((machine_t *)NULL, fd);

	return res;
}

static int
builtin_lseek(fd, offset, whence)
int fd;
off_t offset;
int whence;
{
	return fd_ok(fd) ? lseek(fd, offset, whence) : -1;
}

static int
builtin_pipe(fds)
int *fds;
{
	int res;

	if ((res = pipe(fds)) == 0) {
		ci_register_fd((machine_t *)NULL, fds[0]);
		ci_register_fd((machine_t *)NULL, fds[1]);
	}

	return res;
}

static int
builtin_dup(fd)
int fd;
{
	int res;

	if ((res = dup(fd)) != -1)
		ci_register_fd((machine_t *)NULL, res);

	return res;
}

static int
builtin_dup2(fd, newfd)
int fd, newfd;
{
	int res;

	if ((res = dup2(fd, newfd)) != -1) {
		if (!ci_fd_is_registered((machine_t *)NULL, newfd))
			ci_register_fd((machine_t *)NULL, newfd);
	}

	return res;
}

static FILE *
builtin_fopen(path, mode)
const char *path, *mode;
{
	FILE *fp;

	fp = fopen(path, mode);

	if (fp != NULL)
		ci_register_fd((machine_t *)NULL, fileno(fp));

	return fp;
}

static int
builtin_fclose(fp)
FILE *fp;
{
	ci_unregister_fd((machine_t *)NULL, fileno(fp));
	return fclose(fp);
}

static FILE *
builtin_freopen(path, mode, fp)
const char *path, *mode;
FILE *fp;
{
	ci_unregister_fd((machine_t *)NULL, fileno(fp));

	fp = freopen(path, mode, fp);

	if (fp != NULL)
		ci_register_fd((machine_t *)NULL, fileno(fp));

	return fp;
}

static FILE *
builtin_popen(cmd, mode)
const char *cmd, *mode;
{
	FILE *fp;

	fp = popen(cmd, mode);

	if (fp != NULL)
		ci_register_fd((machine_t *)NULL, fileno(fp));

	return fp;
}

static int
builtin_pclose(fp)
FILE *fp;
{
	ci_unregister_fd((machine_t *)NULL, fileno(fp));
	return pclose(fp);
}

static Display *
builtin_XOpenDisplay(display_name)
const char *display_name;
{
	Display *dpy;

	dpy = XOpenDisplay(display_name);

	if (dpy != NULL)
		ci_register_fd((machine_t *)NULL, ConnectionNumber(dpy));

	return dpy;
}

static int
builtin_XCloseDisplay(dpy)
Display *dpy;
{
	ci_unregister_fd((machine_t *)NULL, ConnectionNumber(dpy));
	return XCloseDisplay(dpy);
}

static voidptr
builtin_calloc(count, size)
size_t count, size;
{
	size_t nbytes;
	voidptr p;

	nbytes = count * size;

	p = ci_mem_malloc((machine_t *)NULL, size);

	if (p != NULL)
		memset(p, '\0', nbytes);

	return p;
}

static voidptr
builtin_malloc(size)
size_t size;
{
	return ci_mem_malloc((machine_t *)NULL, size);
}

static voidptr
builtin_realloc(p, size)
voidptr p;
size_t size;
{
	return ci_mem_realloc((machine_t *)NULL, p, size);
}

static void
builtin_free(p)
voidptr p;
{
	ci_mem_free((machine_t *)NULL, p);
}

/*  BUG: this sucks.
 */
void
cx_set_environ(envp)
char **envp;
{
	Builtin_environ = envp;
}

libfunc_addr_t *
cx_get_libfuncs(count)
size_t count;
{
	if (count != N_LIBFUNCS)
		panic("libvar count botch");

	return Libfunc_addrs;
}

char **
cx_get_libvars(count)
size_t count;
{
	if (count != N_LIBVARS)
		panic("libvar count botch");

	return Libvar_addrs;
}
