/* failmesg.c - produce error messages for system call failures */

/*  Copyright 1994 Mark Russell, University of Kent at Canterbury.
 *
 *  You can do what you like with this source code as long as
 *  you don't try to make money out of it and you include an
 *  unaltered copy of this message (including the copyright).
 */

char utils_failmesg_sccsid[] = "@(#)failmesg.c	1.2 9/4/95 (UKC)";

#include <errno.h>
#include <stdio.h>
#include <local/ukcprog.h>

#include "utils.h"

#ifndef __FreeBSD__
#ifdef __linux__
extern const char *const sys_errlist[];
extern int sys_nerr;
#else
extern const char* sys_errlist[];
extern int sys_nerr;
#endif
#endif

void
failmesg(mesg, what, path)
const char *mesg, *what, *path;
{
	const char *errno_str;

	errno_str = get_errno_str();
	
	if (what == NULL || *what == '\0')
		errf("%s %s: %s", mesg, path, errno_str);
	else
		errf("%s %s %s: %s", mesg, what, path, errno_str);
}

const char *
get_errno_str()
{
	static char buf[40];
		
	if (errno > 0 && errno < sys_nerr && *sys_errlist[errno] != '\0')
		return sys_errlist[errno];
	
	sprintf(buf, "[errno=%d (unknown value)]", errno);
	return buf;
}
