/* xwalld_main.c: main file for xwalld 1.1.
 * tian
 *       than@lucent.com
 *       tian@aluxpo.micro.lucent.com
 */
#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <string.h>
#include <errno.h>
#include <signal.h>

extern FILE* yyin;
extern int yyparse();


static void usage(char *prog_name)
{
   fprintf(stderr, 
           "usage: %s -f fifo_name\n", 
           strrchr(prog_name,'/')==NULL? prog_name : strrchr(prog_name,'/')+1);
   fprintf(stderr, "   -f fifo_name   the file name of the named pipe to be read\n");
   exit(1);
}

void main(int argc, char **argv)
{
    pid_t         orphan;
    char          *fifo_name=NULL;

    {
         struct stat   statv;
         int           i;

         if(argc == 999 ) {
             /* this message is for strings(1). */
             printf("Here!!!.\n");
             printf("the source is in tian's pub/src. tian@aluxpo.micro.lucent.com, x7668. \n");
          }

          /* check the usage */
          for(i=1; i<argc; i++) {
              char *arg = argv[i];
              if(arg[0] == '-') {
                    switch (arg[1]) {
                       case 'f': if(++i >= argc) usage(argv[0]);
                                 fifo_name = argv[i];
                                 continue;
                       default : usage(argv[0]);
                    }
              }
          }
          if( ! fifo_name) usage(argv[0]);
      
          /* make sure we will open an FIFO, and it's readable. */
          if( stat(fifo_name, &statv) ) {
               perror("stat()");
               fprintf(stderr, 
                       "%s: %s is not a valid path name.\n", 
                       argv[0], fifo_name);
               exit(1);
          }
          /* check whether FIFO */
          if( ! (statv.st_mode & S_IFIFO) ) {
               fprintf(stderr, 
                       "%s: %s is not an FIFO.\n", 
                       argv[0], fifo_name);
               exit(1);
          }
          /* check readablility. */
          if( access(fifo_name, R_OK) == -1 ) {
               fprintf(stderr, "%s: %s is not readable.\n", argv[0], fifo_name);
               exit(1);
          }
    
    }

    /* first fork to return the shell to the caller */
    if( (orphan=fork()) == (pid_t)-1 ) {
         perror("fork()");
         exit(1);
    } else if( orphan == (pid_t)0 ) {
         pid_t slave;

         /* to save cpu resource */
         nice(39);

         /* second fork to make a master and a slave.
          * the master will be monitoring whether the FIFO is still available.
          * if not, master will kill the slave and exit itself.
          * without master, the slave will run away.
          * while the slave will keep trying to open the FIFO to read sth.
          */
         if( (slave=fork()) == (pid_t)-1 ) {
              perror("fork()");
              exit(1);
         } else if( slave != (pid_t)0 ) {
             /* master */
             while(1) {
                 sleep(300);   /* have a long sleep */
                 if( access(fifo_name, F_OK) || access(fifo_name, R_OK) ) {
                      if( kill(slave, SIGKILL) ) {
                          perror("kill(slave, SIGKILL");
                          if(errno == ESRCH ) {
                              fprintf(stderr, 
                                      "%s: slave died before master kills it.\n",
                                       argv[0]);
                          }
                      }
                      break;
                 }
             }  
             exit(0);
        } else {
             /* slave */
             while(1) {
                 int  fd;    /* file descriptor */
         
                 /* use O_RDONLY without O_NDELAY or O_NONBLOCK
                  * to get blocked when no writer on the other end. 
                  * this save consume much cpu resource.
                  */
                 if( (fd=open(fifo_name, O_RDONLY)) == -1 ) {
                      perror("open");
                      break;  
                 }

                 /* fprintf(stderr, "not blocked.\n"); */

                 if( (yyin=fdopen(fd, "rb")) == NULL ) {
                      fprintf(stderr, "%s: yyin=fdopen(fd, \"r\") failed.\n", argv[0]);
                      break;
                 }
                
                 /* yyparse() will block until xwalld.y return */
#ifdef DEBUG
                 {
                     if( ! yyparse() ) printf("yyparse ok ");
                     else              printf("yyparse failed.\n");
                 }
#else
                 yyparse();
#endif
                 
                 /* close the input stream */
                 fclose(yyin);
             } 
        }
    } 
}
