#!/bin/sh

. /usr/X11/lib/X11/xdm/Sessreg.rc

XDM_PID_FILE="/etc/xdm-pid"

XDM_ROOT_PID="`cat ${XDM_PID_FILE} | sed 's/^[ ]*//`"

XDM_PIDS="`ps -u root -o pid,ppid | tail +2 |awk '{ if($2==xdm_ppid) print $1 }' xdm_ppid=${XDM_ROOT_PID} | sort -n`"

/usr/X11/bin/update_utmpx ${XDM_PIDS}

cd ${XDM_LINES_DIR}
XDM_LINES=`/bin/ls`

# this command is seldom used and only root. so we don't care its efficiency.
for LINE in ${XDM_LINES}
do
   found=0;
   for PID in ${XDM_PIDS}
   do
      if [ "${LINE}" = "${PID}" ]; then
          found=1;
      fi
   done
   if [ found -eq 0 ]; then
      /bin/rm -f ${XDM_LINES_DIR}/${LINE}
   fi
done
