.\" tian's man page.
.TH UPDATE_UTMPX 1 "Jan 17 1997" "Lucent Technologies "
.SH NAME
update_utmpx \- update Solaris2's utmpx entries for non-init clients
.SH SYNOPSIS
.B update_utmpx
[-u \fIutmpx-file\fP]
[-l \fIxdm-lines-dir\fP]
[-x \fIxslot-start\fP]
[\fIxdm-pid\fP [\fIxdm-pid\fP ...]]
.SH DESCRIPTION
.PP
\fIUpdate_utmpx\fP cleans the obsolete records in \fIutmpx-file\fP
left by xdm(1). This usually becasue xdm is shutdown (e.g. by kill -9)
so that it has no
chance to clean its record in \fIutmpx-file\fP. The \fIxdm-pid\fP are
the valid xdm instances should have been recorded in \fIutmpx-file\fP.
If no xdm-pid is specified, \fIupdate_utmpx\fP will remove all xdm
entries no matter whether they are running. The only effect the out
put of \fIfinger\fP(1).
.SH OPTIONS
.IP "\fB-u\fP \fIutmpx-file\fP"
This specifies the \fIutmpx\fP(4) to be operated. "/var/adm/utmpx" 
defaut.
.IP "\fB-l\fP \fIxdm-lines-dir\fP"
This tell \fIupdate_utmpx\fP the directory where the xdm virtual
ttys locate. For more detail, see tsessreg(1). "/dev/xdm" or simply
"xdm" by default.
.IP "\fB-x\fP \fIxslot-start\fP"
This is a positive integer (default 0). It is usuallythe number 
of the entry below which we will log the xdm authenticated sessions. 
For more detail, see tsessreg(1).
But note that the default here is different from tsessreg(1) in order to
make a complete clean.
.SH "USAGE"
It's the user's duty to find all the \fIxdm-pid\fPs. The following will
be helpful
.IP
XDM_PID_FILE="/etc/xdm-pid"
.br
XDM_ROOT_PID="`cat ${XDM_PID_FILE} | sed 's/^[ ]*//`"
.br
XDM_PIDS="`ps -u root -o pid,ppid | tail +2 |\\
.br
awk '{ if($2==xdm_ppid) print $1 }' \\
.br
xdm_ppid=${XDM_ROOT_PID}`"
.br
update_utmpx ${XDM_PIDS}
.SH "SEE ALSO"
xdm(1), sessreg(1), fwtmpx(1), tsessreg(1), utmpx(4)
.SH AUTHOR
Tianhua Han, Lucent Technology, \fIthan@lucent.com\fP
