/*
 * author: tianhua han, 
 *         than@lucent.com
 *         tian@aluxpo.micro.lucent.com
 */                       

#include <utmpx.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <fcntl.h>

/* check whether it's an integer */
static int isInt(char *string)
{
   int i;
   for(i=0; i<strlen(string)-1; i++) 
      if( ! isdigit((char)string[i]) ) return 0;
   return 1;
}

static void usage (char *program_name)
{
      fprintf(stderr, "usage: %s [-u utmpx_file] [-l xdm_lines_dir] [-x xslot_start] xdm_pid [xdm_pid ...]]\n", program_name);
      fprintf(stderr, "  -u utmpx_file    wtmpx file name, default /var/adm/utmpx\n");
      fprintf(stderr, "  -l line_name_dir the dir for xdm virtual lines. default xdm, i.e. /dev/xdm.\n");
      fprintf(stderr, "  -x xslot_start  the number of the entry below which log xdm connect records \n");
      fprintf(stderr, "                  default 0.\n");
      fprintf(stderr, "  -p xdm_pid       the process id of the xdm instance handling this x-session.\n");
      exit (1);
}

#define MAX_PID 512 

void main(int argc, char **argv)
{
   int    i, j, total_xdm, uxfd, xslot_start=0, valid_xdm_entry,
          trylock, maxtrylock=10, size_of_utmpx=sizeof(struct utmpx);
   char   *utmpx_file="/var/adm/utmpx", *xdm_lines_dir="xdm";
   struct utmpx entryx, zeroentry;
   struct flock otlock, mylock;
   pid_t  xdm_pid[MAX_PID];

   /* message for strings(1) */
   if(argc == 999 ) {
        /* this message is for strings(1). */
        printf("Here!!!.\n");
        printf("the source is in tian's pub/src. tian@aluxpo.micro.lucent.com, x7668. \n");
   }

   j=0;
   for(i=1; i<argc; i++) {
       char *arg = argv[i];
       if(arg[0] == '-') {
          switch (arg[1]) {
             case 'u':
                if(++i >= argc) usage(argv[0]);
                utmpx_file = argv[i];
                continue;
             case 'l':
                if(++i >= argc) usage(argv[0]);
                if(strstr(xdm_lines_dir, "/dev/") != NULL) xdm_lines_dir = argv[i]+5;
                else                                       xdm_lines_dir = argv[i];
                continue;
             case 'x':
                if(++i >= argc) usage(argv[0]);
                if( ! isInt(argv[i])) {
                     fprintf(stderr, "xslot_start is an integer (default 300).\n");
                     usage(argv[0]);
                }
                xslot_start = atoi(argv[i]);
                if( 0>xslot_start || 600<=xslot_start) {
                     fprintf(stderr, "xslot_start out of range (100 to 600 inclusive.).\n");
                     usage(argv[0]);
                }
                continue;
             default:
                usage(argv[0]);
          }
       } else {
                if(j >= MAX_PID) {
                    fprintf(stderr, 
                            "%s: enormously many (more than %d) xdm instances. \n",
                            argv[0], MAX_PID);
                    exit(1);
                }
                if( ! isInt(argv[i])) {
                     fprintf(stderr, "xdm_pid is the pid of your xdm session.\n");
                     usage(argv[0]);
                }
                xdm_pid[j] = (pid_t)atol(argv[i]);
                j++;
       }
   }
   total_xdm = j;

   if( (uxfd=open(utmpx_file, O_RDWR)) == -1) {
       perror("open utmpx");
       exit (1);
   } 

   /* to reduce the complexity of searching, all x entries are put
    * near the bottom of account files
    */
   if( lseek(uxfd, (long)((long)xslot_start*size_of_utmpx), 0) == -1 ) {
       perror("(int)lseek(uxfd, (long)((long)xslot_start*size_of_utmpx), 0)");
       exit(1);
   }
        
   mylock.l_type   = F_WRLCK; /* a write lock (exclusive) */
   mylock.l_whence = SEEK_CUR; /* from current file pointer */
   mylock.l_start  = 0;        /* start right at mylock.l_whence */
   mylock.l_len    = 0;        /* lock up to the end. */ 
   mylock.l_pid    = getpid(); /* don't use xdm_pid, which is this ps' grandfa*/

   bcopy(&mylock, &otlock, sizeof(otlock));

   trylock=0;
   while( fcntl(uxfd, F_SETLK, &mylock) == -1) {
        /* if Set lock fails, find out who has locked the file. */
        if( fcntl(uxfd, F_GETLK, &otlock) != -1 && otlock.l_type != F_UNLCK ) {
             (void) fprintf(stderr, 
                     "%s is locked by process %d from for %d to %d for %s.\n",
                     utmpx_file,
                     (int)otlock.l_pid,
                     (int)(otlock.l_start/size_of_utmpx + xslot_start),
                     (int)(otlock.l_len/size_of_utmpx),   
                     (mylock.l_type == F_WRLCK ? "writing" : "reading") );
        } 
        if( trylock >= maxtrylock ) {
              (void) fprintf(stderr,
                             "%s failed due to file %s is locked. \n%d times has been tried.\n",
                             argv[0], utmpx_file, maxtrylock);
              exit (1);
        } 
        trylock ++;
        (void) sleep(1);
   }
         
   bzero((char*)&zeroentry, size_of_utmpx); 
   while( read(uxfd, (char *) &entryx, size_of_utmpx) == size_of_utmpx ) {
       /* first, try to reclaim one if possible, this is based on the 
          uniqueness of display name at one time. and if you don't reclaim 
          it yourself, no one else could do it for you -- it just wastes.
       */
       if( strstr(entryx.ut_line, xdm_lines_dir) != NULL ) {
           valid_xdm_entry = 0;
           for(i=0; i<total_xdm; i++ ) {
              if( entryx.ut_pid ==  xdm_pid[i] ) {
                  valid_xdm_entry = 1;
                  break;
              }
           }
           if( !valid_xdm_entry ) {
              if( lseek( uxfd, (long)(-size_of_utmpx), SEEK_CUR) == -1) {
                    perror("lseek(uxfd,(long)(-size_of_utmpx),SEEK_CUR) failed.");
                    exit (1);
              }
              if(write(uxfd,(char *)&zeroentry,size_of_utmpx) != size_of_utmpx) { 
                    perror("write utmpx");
                    exit(1);
              }
           }
       }
   }
              
   mylock.l_type   =  F_UNLCK;
   mylock.l_whence =  SEEK_SET;
   mylock.l_start  =  (long) xslot_start*size_of_utmpx;
   mylock.l_len    =  0;
   if(fcntl(uxfd, F_SETLKW, &mylock) == -1) {
        perror("when unlock, fcntl(uxfd, F_SETLKW, &mylock) == -1 failed.");
   }     

   (void) close(uxfd);

   exit(0);
}
