/*
 * author: tianhua han, 
 *         than@lucent.com
 *         tian@aluxpo.micro.lucent.com
 */                       

#include <utmpx.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>


void main(int argc, char **argv)
{
   struct utmpx entryx;
   char   *time_str, *new_line;
   int    fd=0;

   if(argc>1) {
       if( (fd=open(argv[1], O_RDONLY)) == -1 ) {
           perror("open");
           exit(1);
       }
   }

   while( read(fd, (char *) &entryx, sizeof(entryx)) == sizeof(entryx) ) {
       time_str = ctime(&entryx.ut_xtime);
       /* convert new_line into null */
       new_line = (char *) strchr(time_str, (int)'\n');
       *new_line = '\0';
       (void) printf("%10s %4.4s %12.12s %8ld %25s term=%d exit=%d %.30s \n", 
                      entryx.ut_user, 
                      entryx.ut_id, 
                      entryx.ut_line,
                      entryx.ut_pid,
                      time_str,
                      entryx.ut_exit.e_termination,
                      entryx.ut_exit.e_exit,
                      entryx.ut_host
             );
   }
   (void) close(0); 
   exit(0);
}
