#! /usr/local/bin/perl
# CONFIG: change the line above to point to your copy of perl.
##############################################################################
# Glasgow RXX -- Remote eXecution of X programs.  version 4.2.3
#
# Copyright 1992-1995 Duncan Sinclair <sinclair@dis.strath.ac.uk>
#
# Last Modified:  Very early 1995.
#
# Distribution limited, as per the usual MIT copyright.
##############################################################################
# To install, put rxx in your bin and make rxterm a link to it.
#  Some configuration will be necessary, see "CONFIG" comments...
##############################################################################
# Version 4.2.3 makes it perl 5 compatible.
# Version 4.2.2 is a version hike, for no reason.
# Version 4.2.1 is a tidy up of 4.2 for release, with bug-fixes.
##############################################################################
# Notes on new version 4.2!
#
# Rxx now send the remote commands over the network connection to an remote
#  shell to interpret, rather than sending them as the actual command.  This
#  has a number of results:
#   *) No limit to the length of remote commands any more.
#   *) Magic cookies are no longer seen on command lines.
#   *) cleaner coding.
#   *) can now do conditional variable assignment.
##############################################################################
# Notes on new version 4.1!
#
# Rxx can now take *no* arguments.
# Rxx will use a ~/.rxx.data file to decide what to do in this case.
#  it can either use a default, or use the "last" host.  It is
#  possible to default to "this host", if required.
# If you don't want to give it a host, but do want to specify a command,
#  that's ok - put a "-" or "--" where the host should be.
# 
##############################################################################
# This code tries to be intelligent in the way it works.  This means there
#  are tons of implicit assumptions about the environment it is run in.
#  These assumptions are all valid on the machines I use, and in my
#  environment.  At the same time, I try to make as few assumptions as possible
#  about the remote machine.  Here's a list of all the more tricky ones...
# *) That the remote machine has csh.  (Linux?)
# *) That $RSHELL = /bin/(k)?sh ==> remote shell = /bin/(k)?sh.  (Make same.)
# *) If remote shell = sh, that $PATH is compatible.  (Use csh, etc..)
# *) I pass a cookie to the remote machine if need be, but does it
#    know what to do with a cookie. (eat it?)
# *) There must be others...
#
# Why am I using csh to run the remote commands?  Simply because it doesn't
#  interact badly with rsh, and hang waiting for a file descriptor to
#  be closed.  I'd rather use zsh, or perl, but they are not as universal
#  as csh.
##############################################################################
#
# CONFIG:
# Change these variables to be your domain name, and a pattern that
#  will match all variations on your domain name.  You must include
#  those leading dots and trailing '\$'!!!
#
# e.g. $DOM = ".cs.perl.edu" ;
#      $DOMPAT = "\.cs(\.perl(\.edu)?)?\$" ;
#
$DOM  = ".dis.strath.ac.uk" ;
$DOMPAT = "\.dis(\.strath(clyde)?(\.ac\.uk)?)?\$" ;
#
# CONFIG:
# Change this to your value of BINDIR, or set the variable to "" if
#  you think your users are smarter than that.  This is used to find
#  xauth on the local machine.
#
$XPATHS = "/usr/X11/bin" ;
#
# CONFIG:
# Make this the name of your "remote shell" command.
#
# e.g. $RSH = "remsh" ;
#
$RSH = "rsh" ;
#
# CONFIG:
# Does your rsh have this syntax: "rsh -l user host"   ... set to 1
#  or this one:                   "rsh host -l user"   ... set to 0
# If you don't know, it probably doesn't matter.
#
$lfirst = 1 ;
#
# CONFIG:
# Do you want the $PWD transmitted by default?
#  Set to 1 (on) or 0 (off).
#
$pwdhacking = 1 ;
#
# end of CONFIG
#
require "stat.pl";
#
# Some variables we'll no doubt use sometime...
#
# What we called?
($a0 = $0) =~ s:.*/:: ;
$RSHELL = (getpwuid($<))[8] || "/bin/sh" ;
$HOME = $ENV{"DOTDIR"} || $ENV{"HOME"} || $ENV{"LOGDIR"} || (getpwuid($<))[7] ;
$XAUTH = $ENV{"XAUTHORITY"} || $HOME . "/.Xauthority" ;
$BITS = $HOME . "/.rxx.data" ;   # Local
$LAST = $HOME . "/.rxx.last" ;   # Local
$LOGF = "~/.rxx.log" ;           # Remote
@STUFF = () ;
$debug = 0 ;
# Do not force variable values... set to 1 for old behaviour.
$force = 0 ;
# set this variable to 0 for interesting results...
$musthost = 1 ;
# (not) background... not yet implemented..
$back = 1 ;
#
# Before anything else, close stdin.  (Still needed?)
#
close(STDIN);
#
# Usage message...
#
sub usage {
 die "usage: $a0 [[-f file] [-l user] [-p] [-d path]] [[-] [host]] [args...]\n";
}
#
# do some flags...
# ... no longer using "Getopts.pl", cos it doesn't do enuf!
#
while ($_ = $ARGV[0], /^-/) {
  last if /^-[^fldpxXh?-]$/ ;    # If it's not something we recognise...
  shift;
  last if /^--?$/ ;             # We'll take a "-" or a "--" though...
  if (/^-f/) {($opt_f = $ARGV[0]) || &usage ; shift ; } ;
  if (/^-l/) {($opt_l = $ARGV[0]) || &usage ; shift ; } ;
  if (/^-d/) {($opt_d = $ARGV[0]) || &usage ; shift ; } ;
  if (/^-p/) { $opt_p = 1 ; } ;
  if (/^-b/) { $opt_b = 1 ; } ;
  if (/^-x/) { $opt_X = 1 ; } ;
  if (/^-X/) { $opt_X = 1 ; } ;
  if (/^-[h?]/) { &usage ; } ;
}
$musthost &= (!/^--?$/) ;
#
# Now see what we got...
#
if ($opt_f) { $LOGF = $opt_f ; } ;
if ($opt_l) { $User = $opt_l ; @LUser=("-l",$User) ; } ;
if ($opt_d) { $PWD  = $opt_d ; } ;
if ($opt_p) { $pwdhacking = ! $pwdhacking ; } ;
if ($opt_b) { $back  = ! $back ; } ;		# to do...
if ($opt_x) { $force = ! $force ; } ;		# undocumented! Oh dear!
if ($opt_X) { $debug = ! $debug ; } ;		# undocumented! Oh dear!
if ($opt_d && $opt_p) { print stderr "$a0: option '-p' ignored.\n" ; } ;
#
# Where am I?  Seems we can't trust the dumb user to set HOSTNAME right!
#
#$HOSTNAME=$ENV{HOSTNAME} || $ENV{HOST} || `hostname` ;	# Current Host
$HOSTNAME=`uname -n` || `hostname` ;			# Current Host
$HOSTNAME =~ s/\n// ;					# "chop"
$HOSTNAME =~ s/$DOMPAT// ;				# Kill domain
if ( $OffSite ) { $HOSTNAME = $HOSTNAME . $DOM ; } ;	# Now put it back
#
# Pick a host, any host...
#
$MACH = $ARGV[0] ;
unless (defined($MACH) && ($musthost || (@_ = gethostbyname($MACH)))) {
  #
  # If we're going to miss the host...
  #
  $entry = '@same@' ;
  open(BITS,$BITS) && ($entry = <BITS>) && chop($entry) && close(BITS) ;
  #
  # Now look at it...
  #
  if ($entry eq '@last@') {
    open(LAST,$LAST) && ($entry = <LAST>) && chop($entry) && close(LAST) ;
  } 
  if ($entry =~ /@....@/) {
    $MACH = $HOSTNAME ;
  } else {
    $MACH = $entry  ;
  }
} else {
  shift ;
}
#
# Things to think about for the remote machine.
#
$MACH =~ s/$DOMPAT// ;					# Is it really local?
$OffSite = $MACH =~ /\./ ;				# nope.
#
# Now we're going to write out the "last" file...
#
if (open(LAST,">" . $LAST)) {
  print LAST $MACH,"\n" ;
  close(LAST) ;
}
#
# Now we know where we are, and they are, are they different?
#
$Diff = $HOSTNAME ne $MACH ;
#
# What is the display going to be?
# !! Danger !! Heavy Regular expressions follow...
#
$DISPLAY = $ENV{"DISPLAY"} || ":0.0" ;
$DISPLAY =~ s/$DOMPAT// ;
$DISPLAY =~ s/^(unix)?(:\d(\.\d)?)$/$HOSTNAME$2/ if ($Diff) ;
$DISPLAY =~ s/^([^.]*)(:\d(\.\d)?)$/$1$DOM$2/ if ($OffSite) ;
($DISPHOST, $DISPNUM) = split (':',$DISPLAY,2) ;
if ($DISPHOST eq $MACH) { $DISPHOST = "" ; } ;
$DISPLAY = $DISPHOST . ":" . $DISPNUM ;
$ENV{"DISPLAY"} = $DISPLAY ;
#
# Here comes the hard bit in sh.  Quote our args.
# Also have to quote quotes like this; ' -> '\''
# So for an arg "foo'bar", we get "'foo'\''bar'".
#
foreach (@ARGV) {
  s#\'#\'\\\'\'#g ;
  s#(.*)#\'$1\'# ;
}
#
# So what we doing?
#
PROG: {
  if ($a0 eq "rxx.pl") { last PROG ; } ;
  if ($a0 =~ /^rx(x)?(term)?$/) { last PROG ; } ;
  if ($a0 =~ /r(.*)/) { unshift(@ARGV,$1) ; last PROG ; } ;
  warn "$a0: don't recognise my name." ;
}
#
# If nothing else, become an rxterm.
#
if (@ARGV == 0 || $ARGV[0] =~ /^\'[-+]/) {
  unshift(@ARGV,"xterm","-ls","-n",$MACH) ;
}
unshift(@STUFF,"(@ARGV &) </dev/null") ;
#
# Some special considerations if we are not ourselves on the other side.
#
if (($OffSite && ($DISPHOST ne "")) || $User) {
  #
  # We want to pass a cookie here.
  #
  AUTH : {
    if (-e $XAUTH) {
      #
      # Extract the cookie to merge on the remote side...
      #
      if ($DISPHOST ne "") {
	$xacomm="PATH=\$PATH:$XPATHS xauth nextract - $DISPLAY" ;
      } else {
	$xacomm="PATH=\$PATH:$XPATHS xauth nextract - $HOSTNAME/unix:$DISPNUM" ;
      }
      $CooKie = `$xacomm` || next AUTH ;
      chop($CooKie) ;
      unshift(@STUFF,"xauth nmerge - << END_AUTH",$CooKie,"END_AUTH") ;
    } else {
      #
      # Yuk.  What a crock.  I hate doing this.
      #
      system("xhost +$MACH >/dev/null 2>/dev/null") if ($Diff) ;
    }
  }
}
#
# Some less condition stuff...
#
if ($User || $OffSite) {
  #
  # We really only want to pass a value for $DISPLAY.
  #
  @VARS=("DISPLAY", split(' ',$ENV{"RXENV"})) ;
} else {
  #
  # Some variables we wish to export.  Ideally, these would be set in
  #  the user's .cshrc (or equiv.) and I wouldn't waste my time here.
  #
  @VARS=(
    "DISPLAY",
    "XENVIRONMENT",
    "XFILESEARCHPATH",
    "XUSERFILESEARCHPATH",
    "XAPPLRESDIR",
    "OPENWINHOME",
    "LD_LIBRARY_PATH",
    "MANPATH",			# for "rxman", and bourne shell users.
    "XAUTHORITY",
    split(' ',$ENV{"RXENV"}),
    ) ;
  #
  # Braindead bourne shell, needs to be given a $PATH...
  # We would rather not pass the current $PATH, because it might not work
  #  on the destination machine.  I'd rather it was set by the user's
  #  remote shell during the rsh.
  # Fortunately, all *my* X programs are in an arch independant place, and
  #  so it shouldn't cos a problem, locally.
  # We check against $RSHELL, because they might be running another shell,
  #  differant from their login shell.  I know, sounds weird, but it's too
  #  common round here.
  # I've also included ksh in the brain-damage, cos I can't see an easy way
  #  to pass throught $ENV{"ENV"} without it being too late. (We only have
  #  one person who has ksh as a login shell anyway...)
  # Oh, yeah.. we are assuming that if it's bourne shell here, then it's
  #  bourne shell there.  Much more important than this is that it it ISNT
  #  bourne shell here, it better not be bourne shell there.
  #
  if ($RSHELL =~ m#/(k)?sh#) { push(@VARS,"PATH"); } ;
  #
  # Rc suffers the same braindamage... sometimes I wonder whether it's
  #  author ever intended it to be used for any *useful* work.
  #
  if ($RSHELL =~ m#/rc#) { push(@VARS,"PATH"); } ;
}
#
# Validate $PWD routine...
#
sub validate_pwd {
  local(@pwdstats, @dotstats);
  local($pwd) = $_[0];

  unless (defined($pwd))          { return undef; } ;
  unless (@dotstats = stat("."))  { return undef; } ;
  unless (@pwdstats = stat($pwd)) { return undef; } ;
  if (($pwdstats[$ST_DEV] != $dotstats[$ST_DEV]) ||
      ($pwdstats[$ST_INO] != $dotstats[$ST_INO])) { return undef; } ;
  $pwd;
}
#
# Try and find a nice, valid, pwd.
#
PRESENT : {
  if ($pwdhacking) {
    if ($PWD) { last PRESENT ; } ; # User supplied - accept it as real.
    if ($PWD = $ENV{"PWD"}) {   # Find it in the environment.
      $FOOPWD = $PWD ;
      $FOOPWD =~ s#(/tmp_mnt|/export)?/(.*)#/$2# ;
      $PWD = &validate_pwd($FOOPWD) || &validate_pwd($PWD) ;
    }; 
    unless ($PWD) {
      chop($PWD = `pwd`) ;      # OK, so where _actually_ are we?
      $FOOPWD = $PWD ;
      $FOOPWD =~ s#(/tmp_mnt|/export)?/(.*)#/$2# ;
      $PWD = &validate_pwd($FOOPWD) || &validate_pwd($PWD) ;
    };
  }
}
if ($PWD) {
  #
  # Mess around with the log file name...
  #
  unless ($LOGF =~ m:^[/~]:) { $LOGF = $PWD . "/" . $LOGF ; } ;
  #
  # Quote 'em.
  #
  $PWD  =~ s#(.*)#\'$1\'# ;
  #$LOGF =~ s#(.*)#\'$1\'# ;
  #
  # Try to find somewhere nice to live on the other side.
  #
  unless ($OffSite) {
    unshift(@STUFF,"test -d $PWD && cd $PWD");
  }
}
#
# Start building the full command.
#
foreach $var (@VARS) {
  if ($val = $ENV{$var}) {
    if ($force) {
     unshift(@STUFF,"setenv $var \'$val\'") ;
    } else {
     unshift(@STUFF,"if (! \$?$var) setenv $var \'$val\'") ;
    }
  }
}
#
# Some commands to do on the other side...
#
unshift(@STUFF,"set nonomatch") ;
$umask = sprintf("0%lo", umask) ;
unshift(@STUFF,"umask $umask") ;
#
# Build the remote commands.
#
$SEND=join("\n",@STUFF) ;
#
$REMOTE="\'umask 077 ; exec csh -f >&$LOGF\'" ;
#$REMOTE = "\'" . $REMOTE . "\'" ;
#
# Build the arg list for the exec.
#
if ($lfirst) {
  @COMM=($RSH,@LUser,"$MACH","csh","-fc",$REMOTE) ;
} else {
  @COMM=($RSH,"$MACH",@LUser,"csh","-fc",$REMOTE) ;
}
#
# Do it!
#
if ($debug) {
  print "@COMM\n" ;
  $pid = open (PIPE,"|-") || exec 'cat' ;
} else {
  $pid = open (PIPE,"|-") || exec @COMM ;
}
if (defined($pid)) {
  print PIPE "$SEND\n" ;
  close (PIPE);
  die "$a0: error while sending remote command.\n" if $? ;
} else {
  die "$a0: error while starting remote command.\n" ;
}
#
# After this point we have no idea what is happening on the remote
#  side.  In theory we can improve on this by more careful redirection
#  of remote errors, but the important stuff would still be lost.
#
exit 0 ;
#
# tHe ENd
