.TH RXX 1 "4 January 1995" "X Version 11"
.SH NAME
rxx,r* - remote execution of X programs.
.SH SYNOPSIS
.B rxx
[[
.B \-f
.I file
]
[
.B \-l
.I user
]
[
.B \-p
]
[
.B \-d
.I path
]]
[[
.B -
]
[
.I host
]]
[
.I args...
]
.SH DESCRIPTION
The 
.B rxx
program connects to a possibly inplicitly specified
.I host
and executes the specified
.I command
in the background, returning immediately.  To allow the execution
of X programs, it copies a number of environmental variables to
the remote session.  If you omit
.IR command
or it appears to be command options, rather than an actual command,
then
.B rxx
will start an xterm on the remote host.
.PP
If you omit the hostname it will choose a host based on the first line
of the file
.B ~/.rxx.data
if it exists.  If this is the special string "@same@", then it will
use the same host as you are on.  If it is the special string "@last@"
then it will use the last host that you rxx-ed to, as found in the file
.BR ~/.rxx.last .
Otherwise it takes the contents of the line as a hostname, and will use that.
.\" The deprecated
.\" .B rxterm
.\" variant starts a remote xterm on a host, and also passes
.\" .I command args...
.\" to the remote xterm as arguments.
.PP
Shell meta-characters which are not quoted are interpreted on the local
machine, while quoted meta-characters are interpreted on the remote
machine.
.PP
Unless you specify the
.I \-p
option,
.B rxx
will attempt to execute the remote command in the same directory as you
are currently in on the local machine.  Or if you specify the
.IB \-d directory
option, it will instead use that as the remote directory.  Rxx takes extra
care to try and avoid Sun's automounter from thwarting this process.
.PP
If the name of the file from which
.B rxx
is executed is anything other than ``rxx,'' ``rx'', or ``rxterm,'' then
.B rxx
takes this name, stripped on a leading ``r'' as the command
to run on the remote host, using any
.I command args...
parameters as arguments for the remote command.
.PP
If
.B rxx
thinks you are using
.B xauth
based X authorisation, and you are calling to a off-site host, or
to a different username, it will attempt to copy an authorisation
key to the remote account.  Otherwise it will try to use
.B xhost(1)
to grant access to the remote host.  It is possible to set a configuration
option to always attempt to pass the authorisation key where a homogenious
file system does not exist in a local site.
.SH OPTIONS
.TP
.BI \-f " file"
Use
.I file
to catch any output from the remote command instead of the default file
.I ~/.rxx.log
.  This file can either be absolute, or else it will be taken as relative
the remote directory.
.TP
.BI \-l " user"
Use
.I user
as the remote username instead of your local username.  In the absence
of this option, the remote username is the same as your local username.
.TP
.B \-p
Use of this flag disables the remote directory manipulation, and can speed
up execution when the remote directory is not important.
.TP
.BI \-d " directory"
Use
.I directory
on the remote machine to run the remote command in.  If this directory does
not exist, the command will be run in the remote user's home directory.
.TP
.B \-
Use of this flag marks the end of options to be understood by rxx, and
is recommended if you wish to supply arguments to both rxx and a remote
command.

.SH EXAMPLES
.TP 30
``rxx barra'' :
A simple remote xterm.
.TP
``rxx barra -iconic'' :
A remote xterm with flags.
.TP
``rxx -p barra xman'' :
A remote xman session.
.TP 10
``rxx -d /X/src -f make.world -l x11 barra make World'' :
A remote make command as a different user in a different directory
saving output in make.world.
.SH ENVIRONMENT
If set, the values of PATH, DISPLAY, XENVIRONMENT, XAPPLRESDIR,
XFILESEARCHPATH, XUSERFILESEARCHPATH, OPENWINHOME, LD_LIBRARY_PATH,
and XAUTHORITY are exported to the remote program, unless the
remote username is different, or the remote host is off-site, in which
case only DISPLAY is exported, with in all cases any variables named in the
variable RXENV.
.PP
The DISPLAY variable is tweaked as appropriate, to contain as qualified
a hostname as is needed.
.SH DIAGNOSTICS
.TP
.IB command ": don't recognise my name."
.B rxx
cannot decode the name it has been called under.  In this case
it prints a warning message, and continues, as normal.
.TP
.B "usage: rxx ..."
This means it could not decode the arguments given to it.
.SH AUTHOR
Duncan Sinclair <sinclair@dis.strath.ac.uk>, January 1995
.PP
Originally based on a program called "rx" in an older
.B gwm
distribution.  The name has recently been changed to 
.B rxx
to distinguish it from both related and unrelated programs with similar names.
.SH FILES
.TP 15
~/.rxx.log
Default file to catch remote command output.
.SH "SEE ALSO"
X(1), rsh(1), xterm(1), xauth(1), xhost(1), gwm(1), umask(1), csh(1)
.SH BUGS
Documentation is not up-to-date.
.PP
.B Rxx
makes a number of assumptions about the relationship between the
local user, and the remote one, depending on whether the remote
host is on-site or not, and whether an alternative username was used
or not.
.PP
In particular, if either the locally used shell, or the remotely
used shell is the standard Bourne Shell,
.B sh(1)
then strange things are more likely to happen.  Especially when 
it's only one of them.
.PP
Sometimes (rarely) quoting can get messed up.
.PP
It's too easy to fool the smarts in
.B rxx
to make it believe something that is not true, and fail because of it.
.PP
When
.B rxx
uses
.B xhost
to grant access, the
.B xhost
command may fail silently.
.PP
.\"If
.\".B rxx
.\"tries to send to large a command to the remote machine, it will
.\"likely fail with a parse error from csh.  If this happens, you
.\"will probably have to reduce the size of the exported environment.
.\".PP
Users should ensure that their shell search path is set
correctly in their .cshrc file or equivalent.  This is necessary for
all remote execution to work smoothly, and is not just a feature of
.B rxx.
.PP
.B Rxx
assumes that sites in the same domain are in a NFS environment where
a user will have one global home directory.  If this is not the case, then
some small small modifications to
.B rxx
may be necessary.
