 /*-------------------------------------------------------------------------------*\
| XtMacro.h: 11/01/95 (C) Raoul olivier                                             |
| description: Macro for creation of widget tree                                    |
| example:                                                                          |
|   APPINITIALIZE(&app,"Workbench",NULL,0,                                          |
|		  &argc,argv,                                                       |
|		  NULL,                                                             |
|		  CHILD("row",groupWidgetClass,                                     |
|			CHILD("push",xmPushButtonWidgetClass, XmNwidth,100,         |
|			      CALLBACK(XmNactivateCallback,Callback,1),             |
|			      END),                                                 |
|			END),                                                       |
|		  REALIZE,                                                          |
|		  ENDINTERFACE);                                                    |
 \*-------------------------------------------------------------------------------*/

#ifndef XTMACRO_H
#define XTMACRO_H
#include <X11/Intrinsic.h>

struct MethodData
{
  Widget dest;
  String ressrc;
  String resdst;
}; 

extern Widget topwidget;
#define CHILDGENERIC(x)  NULL),x XtMacroCreateWidget
#define CHILD  CHILDGENERIC( )
#define GETCHILD(x) CHILDGENERIC(x =)
#define END NULL),PullChild(), Nothing( Nothing(
#define INTERFACE PushChild
#define ENDINTERFACE NULL),GetChild(
#define GetParent GetChild()
#define CALLBACK(name,func,calldata) NULL),XtAddCallback(GetParent,name,(XtCallbackProc)func,(XtPointer)calldata),Nothing( NULL
#define EVENTHANDLER(name,mask,func,calldata) NULL),XtAddEventHandler(GetParent,name,mask,(XtEventHandler)func,(XtPointer)calldata),Nothing( NULL
#define APPINITIALIZE XtMacroAppInitialize
#define REALIZE NULL),XtRealizeWidget(GetParent),Nothing( NULL
/* PROTO XtMacro.c */
#ifdef __STDC__
# define	P(s) s
#else
# define P(s) ()
#endif


/* XtMacro.c */
void PushChild P((Widget w , ...));
Widget GetChild P((void ));
void PullChild P((void ));
int Nothing P((...));
Widget XtMacroCreateWidget P((char *name , WidgetClass widget_class , ...));
Widget XtMacroAppInitialize P((XtAppContext *app_context_return , String application_class , XrmOptionDescList options , Cardinal num_options , int *argc_in_out , String *argv_in_out , String *fallback_resources , ...));
void CallbackMethodProcess P((Widget source , struct MethodData *data , XtPointer p ));
void CallbackMethodDestroy P((Widget source , struct MethodData *data , XtPointer p ));
void DoMethod P((Widget source , String callback , String ressrc , Widget dest , String resdst ));
void DoMethodDouble P((Widget source , String callback , String ressrc , Widget dest , String resdst ));

#undef P
#endif
