/*
 * main.c
 *
 * Eric Dumas (dumas@emi.u-bordeaux.fr)
 *
 * $Id:$
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <unistd.h>

#ifdef MAP_MOTIF
#include <Motif/Motif_look.h>
#endif

#include <maprusers.h>
#include <config.h>
#include <map+_cfg.h>
#include <bad_host.h>

data_internal_t list_host;

#define NB_VERSION      "1.0"
#define DEFAULT_PLACE   0
#define HELP_CMD        "--help"

void usage(config_file_t   config_data)
{
    int i;
    
    fprintf(stderr, "======== Map + ========\n");
    fprintf(stderr, "(c) E.D 1995  Version : %s \n", NB_VERSION);
    fprintf(stderr, "======== Map + ========\n");
    fprintf(stderr, "usage : \n");
    fprintf(stderr, "map+\n");
    fprintf(stderr, "Options possibles : \n");
    fprintf(stderr, "Aide : %s \n", HELP_CMD);

    for (i=0 ; i < get_nb_room(config_data) ; i++)
        fprintf(stderr," %s ",get_name_room(config_data,i));
    
    fprintf(stderr,"\n");
    
    exit(1);
}

int go(char *name,config_file_t   config_data )
{
    int i,j, nb=-1;
    int flag;
    
    init_bad_host();

    for (i=0 ; i < get_nb_room(config_data) ; i++)
    {
        if (!strcmp(name, get_name_room(config_data,i)))
        {
            for (j=0 ; j < get_width_room(config_data,i)*
                 get_height_room(config_data,i) ; j++)
                if (get_name_station(config_data, i, j) == NULL)
                    set_bad_host_val(j,-1);
                else
                {

                    list_host = onehost(list_host, &flag,
                                       get_name_station(config_data,i,j));
                    if (!flag)
                    {
                        set_bad_host_ptr(j, get_name_station(config_data,i,j));
                        set_bad_host_val(j,0);
                    }
                }
            nb = get_width_room(config_data,i)*get_height_room(config_data,i);
            set_rusers_width(list_host,  get_width_room(config_data,i) );
            set_rusers_height(list_host, get_height_room(config_data,i));        
        }
    }
    

    if (nb == -1)
    {
        list_host = onehost(list_host, &flag, name);
        
        if (!flag)
        {
            set_bad_host_ptr(0, name);
            set_bad_host_val(0,0);
            nb = 0; 
        }
        else 
            nb = 1;
    }

    set_number_host(nb);
    
    if (nb == 0)
        return 0; 

    alloc_widgets(nb);

    return nb;
}

void main(int argc, char *argv[])
{
    int nb;
    config_file_t   config_data;

    config_data = load_config_file(CONFIG_FILE);

    list_host = NULL;
    init_interface(argc, argv, config_data);

    nb=0;

    if ((argc == 2) && (!strcmp(HELP_CMD,argv[1])))
        usage(config_data);
    
    fprintf(stderr,"...Initialising...\n");

    if (argc != 2)
        nb = go (get_name_room(config_data,DEFAULT_PLACE),
                 config_data);
    else
        nb = go (argv[1],config_data);

    if (nb == 0)
    {
        fprintf(stderr, " Sorry, no host to be displayed \n");
        usage(config_data);
    }
    
    run_interface(nb);
}




