/*----------------------------------------------------------------------------
--
--  Module:           xitViewText
--
--  Project:          xit  - X Internal Toolkit
--  System:           xit  - X Internal Toolkit
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Create a window with a scrolled text and a Close button.
--
--  Filename:         xitViewText.c
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-06-10
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
static char SCCSID[] = "@(#) Module: xitViewText.c, Version: 1.1, Date: 95/02/18 15:10:51";


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>

#include "xitTools.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

/* Local widgets in the window. */
#define viewTx            dataLocalW[  0 ]


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

void 
  xitViewText( Widget  parent,
               char    *text,
               char    *title,
               char    *close_button )
{

  /* Variables. */
  Arg       args[ 10 ];
  Cardinal  n;
  Widget    dataLocalW[ 1 ];
  Widget    viewFd;
  Widget    workFo;

  static XIT_TEXT_STRUCT text_buffer_def[] = {
    { "ViewTx", NULL, 2, True },
  };

  static XIT_ACTION_AREA_ITEM  action_buttons[] = {
    { NULL, NULL, NULL },
    { NULL, NULL, NULL },
    { "",   NULL, NULL },
    { NULL, NULL, NULL },
    { NULL, NULL, NULL },
  };


  /* Code. */

  action_buttons[ 2 ].label = close_button;


  /* Create a form dialog with buttons. */
  viewFd = xitCreateFormDialog( parent, "ViewTextFd",
                                3, 0,
                                action_buttons,
                                XtNumber( action_buttons ) );

  n = 0;
  XtSetArg( args[ n ], XmNtitle, title ); n++;
  XtSetValues( XtParent( viewFd ), args, n );

  n = 0;
  XtSetArg( args[ n ], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL ); n++;
  XtSetValues( viewFd, args, n );


  /* Contents of the window. */
  workFo = XtNameToWidget( viewFd, "ViewTextFdFo" );


  /* The text window. */
  viewTx = xitCreateTextScrolled( workFo, &text_buffer_def[ 0 ] );

  n = 0;
  XtSetArg( args[ n ], XmNeditable, False ); n++;
  XtSetArg( args[ n ], XmNcursorPositionVisible, False ); n++;
  XtSetValues( viewTx, args, n );


  /* Put the elements together. */
  xitAttachWidget( XtParent( viewTx ),
                   XmATTACH_FORM, NULL, XmATTACH_FORM, NULL,
                   XmATTACH_NONE, NULL, XmATTACH_NONE, NULL );

  /* Make sure there is enough space between the children. */
  n = 0;
  XtSetArg( args[ n ], XmNtopOffset,    5 ); n++;
  XtSetArg( args[ n ], XmNleftOffset,   5 ); n++;
  XtSetArg( args[ n ], XmNrightOffset,  5 ); n++;
  XtSetArg( args[ n ], XmNbottomOffset, 5 ); n++;
  XtSetValues( XtParent( viewTx ),  args, n );


  /* Manage the widgets. */
  xitManageChildren( dataLocalW, XtNumber( dataLocalW ) );

  /* Set the size of the window. */
  xitSetSizeFormDialog( viewFd, True );

  XtManageChild( viewFd );


  /* Final attachments. */
  xitAttachWidget( XtParent( viewTx ),
                   XmATTACH_FORM, NULL, XmATTACH_FORM, NULL,
                   XmATTACH_FORM, NULL, XmATTACH_FORM, NULL );

  XmTextSetString( viewTx, text );


  return;

} /* xitViewText */
