/*----------------------------------------------------------------------------
--
--  Module:           xitSitckyMsg
--
--  Project:          xit   - X Internal Toolkit
--  System:           <>
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Display a message and wait for the user confirm some action. During
--    the time the message is displayed, a local event loop is used.
--
--  Filename:         xitStickyMsg.c
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-11-01
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
static char SCCSID[] = "@(#) Module: xitStickyMsg.c, Version: 1.1, Date: 95/02/18 15:10:49";


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Protocols.h>

#include <Xm/Xm.h>

#include "System.h"

#include "xitTools.h"
#include "xitStickyMsg.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Record for internal data. */
typedef struct {

  /* Is done? */
  Boolean  is_done;

  /* User callbacks. */
  XIT_ST_ACTION_CB  bu1CB;
  XIT_ST_ACTION_CB  bu2CB;
  XIT_ST_ACTION_CB  exitWindowCB;

  /* User data. */
  void  *user_data;

} MSG_REC, *MSG_REC_REF;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

static void 
  bu1CB( Widget       widget,
         MSG_REC_REF  msg_ref,
         XtPointer    call_data );

static void 
  bu2CB( Widget       widget,
         MSG_REC_REF  msg_ref,
         XtPointer    call_data );

static void 
  exitWindowCB( Widget       widget,
                MSG_REC_REF  msg_ref,
                XtPointer    call_data );



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

void
  xitStDisplaySticky( Widget            parent,
                      char              *msg_text,
                      Pixmap            pixmap,
                      char              *bu1_text,
                      char              *bu2_text,
                      XIT_ST_ACTION_CB  userBu1CB,
                      XIT_ST_ACTION_CB  userBu2CB,
                      XIT_ST_ACTION_CB  userExitWindowCB,
                      void              *user_data )
{

  /* Variables. */
  Arg          args[ 10 ];
  Cardinal     n;
  Widget       logoLa;
  Widget       msgLa;
  Widget       msgTl;
  Widget       toplevelW;
  Widget       workFo;
  MSG_REC_REF  msg_ref;

  static XIT_ACTION_AREA_ITEM  action_buttons[] = {
    { "",   bu1CB, NULL },
    { NULL, NULL,  NULL },
    { "",   bu2CB, NULL },
  };


  /* Code. */

  /* Our local setup data. */
  msg_ref = SysNew( MSG_REC );

  msg_ref -> is_done      = False;
  msg_ref -> bu1CB        = userBu1CB;
  msg_ref -> bu2CB        = userBu2CB;
  msg_ref -> exitWindowCB = userExitWindowCB;
  msg_ref -> user_data    = user_data;


  /* Create a separate window. */
  if( bu1_text != NULL ) {
    action_buttons[ 0 ].label = bu1_text;
    action_buttons[ 0 ].data  = msg_ref;
  } else {
    action_buttons[ 0 ].label    = NULL;
    action_buttons[ 0 ].callback = NULL;
  }

  if( bu2_text != NULL ) {
    action_buttons[ 2 ].label = bu2_text;
    action_buttons[ 2 ].data  = msg_ref;
  } else {
    action_buttons[ 2 ].label    = NULL;
    action_buttons[ 2 ].callback = NULL;
  }


  /* Create the message window. */
  toplevelW = xitGetToplevelWidget( parent );

  msgTl = xitCreateToplevelDialog( toplevelW, "StickyMsgTl", 
                                   1, 0,
                                   action_buttons, 
                                   XtNumber( action_buttons ) );

  n = 0;
  XtSetArg( args[ n ], XmNtitle,    " " ); n++;
  XtSetArg( args[ n ], XmNiconName, " " ); n++;
  XtSetValues( msgTl, args, n );


  /* Close the window if this window is deleted. */
  {
    Atom  wm_delete_window;

    wm_delete_window = XmInternAtom( XtDisplay( msgTl ),
                                     "WM_DELETE_WINDOW", False );

    XmAddWMProtocols( msgTl, &wm_delete_window, 1 );
    XmAddWMProtocolCallback( msgTl, wm_delete_window, 
                             (XtCallbackProc) exitWindowCB,
                             (XtPointer) msg_ref );
  } /* block */


  /* Reference to the contents of the window. */
  workFo = XtNameToWidget( msgTl, "StickyMsgTlBase.StickyMsgTlFo" );


  /* Logo label. */
  logoLa = xitCreateLabel( workFo, "LogoLa", " ", -1 );

  if( pixmap != XmUNSPECIFIED_PIXMAP ) {
    n = 0;
    XtSetArg( args[ n ], XmNlabelType, XmPIXMAP ); n++;
    XtSetArg( args[ n ], XmNlabelPixmap, pixmap ); n++;
    XtSetValues( logoLa, args, n );
  }


  /* Message label. */
  msgLa = xitCreateLabel( workFo, "MsgLa", msg_text, -1 );


  /* Put the elements together. */
  xitAttachWidget( logoLa,
                   XmATTACH_FORM, NULL, XmATTACH_FORM, NULL,
                   XmATTACH_NONE, NULL, XmATTACH_NONE, NULL );
  xitAttachWidget( msgLa,
                   XmATTACH_FORM, NULL, XmATTACH_WIDGET, logoLa,
                   XmATTACH_NONE, NULL, XmATTACH_NONE,   NULL );


  n = 0;
  XtSetArg( args[ n ], XmNtopOffset,    5 ); n++;
  XtSetArg( args[ n ], XmNleftOffset,   5 ); n++;
  XtSetArg( args[ n ], XmNrightOffset,  5 ); n++;
  XtSetArg( args[ n ], XmNbottomOffset, 5 ); n++;
  XtSetValues( logoLa, args, n );
  XtSetValues( msgLa,  args, n );


  /* Manage the widgets. */
  XtManageChild( logoLa );
  XtManageChild( msgLa );

  /* Set the size of the window. */
  xitSetSizeToplevelDialog( msgTl, True );


  /* Make sure the setup windoww is visable. */
  XtPopup( msgTl, XtGrabNone );

  XRaiseWindow( XtDisplay( msgTl ), XtWindow( msgTl ) );
  XtMapWidget( msgTl );


  /* Process events until we are done. */
  while( ! msg_ref -> is_done )
    xitDispatchXEvents( msgTl, XtWidgetToApplicationContext( parent ) );


  /* Clean up. */
  SysFree( msg_ref );

  XtDestroyWidget( msgTl );
  XmUpdateDisplay( toplevelW );


  return;

} /* xtmStDisplaySticky */


/*----------------------------------------------------------------------*/

static void 
  bu1CB( Widget       widget,
         MSG_REC_REF  msg_ref,
         XtPointer    call_data )
{

  /* Code. */

  /* Any user callback? */
  if( msg_ref -> bu1CB != NULL )
    (* msg_ref -> bu1CB)( msg_ref -> user_data );

  msg_ref -> is_done = True;


  return;

} /* bu1CB */


/*----------------------------------------------------------------------*/

static void 
  bu2CB( Widget       widget,
         MSG_REC_REF  msg_ref,
         XtPointer    call_data )
{

  /* Code. */

  /* Any user callback? */
  if( msg_ref -> bu2CB != NULL )
    (* msg_ref -> bu2CB)( msg_ref -> user_data );

  msg_ref -> is_done = True;


  return;

} /* bu2CB */


/*----------------------------------------------------------------------*/

static void 
  exitWindowCB( Widget       widget,
                MSG_REC_REF  msg_ref,
                XtPointer    call_data )
{

  /* Code. */

  /* Any user callback? */
  if( msg_ref -> exitWindowCB != NULL )
    (* msg_ref -> exitWindowCB)( msg_ref -> user_data );

  msg_ref -> is_done = True;


  return;

} /* exitWindowCB */




