/*----------------------------------------------------------------------------
--
--  Module:           xitPixmDia
--
--  Project:          xit  - X Internal Toolkit
--  System:           xit  - X Internal Toolkit
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Manages an information dialog where Enter and Return are used as 
--    activate keys. If a pixmap is supplied, it is displayed.
--
--  Filename:         xitPixmDia.c
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1993-03-25
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
static char SCCSID[] = "@(#) Module: xitPixmDia.c, Version: 1.1, Date: 95/02/18 15:10:44";


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>
#include <Xm/MessageB.h>

#include "xitTools.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

static void
  removeCB( Widget               widget,
            Widget               toplevel_widget,
            XmAnyCallbackStruct  *call_data );


/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

Widget 
  xitCreatePixmapDialog( Widget  parent, 
                         char    *dialog_name,
                         char    *title,
                         char    *message,
                         Pixmap  pixmap,
                         void    (*okCB) (),
                         void    *ok_client_data )
{

  /* Variablesf. */
  Arg        args[ 5 ];
  Cardinal   n;
  Widget     button;
  Widget     w;
  XmString   xstr;


  /* Code. */

  n = 0;
  XtSetArg( args[ n ], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL ); n++;
  XtSetArg( args[ n ], XmNnoResize, True ); n++;

  w = XmCreateInformationDialog( parent, dialog_name, args, n );

  if( strlen( message ) > 0 ) {
    xstr = XmStringCreateLtoR( message, CS );

    n = 0;
    XtSetArg( args[ n ], XmNmessageString, xstr ); n++;
    XtSetValues( w, args, n );
    XmStringFree( xstr );
  }

  if( strlen( title ) > 0 ) {
    xstr = XmStringCreateLtoR( title, CS );

    n = 0;
    XtSetArg( args[ n ], XmNdialogTitle, xstr ); n++;
    XtSetValues( w, args, n );
    XmStringFree( xstr );
  }

  /* Unmanage the cancel and help buttons. */
  button = XmMessageBoxGetChild( w, XmDIALOG_CANCEL_BUTTON );
  XtUnmanageChild( button );

  button = XmMessageBoxGetChild( w, XmDIALOG_HELP_BUTTON );
  XtUnmanageChild( button );

  /* Any Pixmap to set? */
  if( pixmap != XmUNSPECIFIED_PIXMAP ) {
    n = 0;
    XtSetArg( args[ n ], XmNsymbolPixmap, pixmap ); n++;
    XtSetValues( w, args, n );
  }


  /* Add callback? */
  if( okCB != NULL ) {
    XtAddCallback( w, XmNokCallback,
                   (XtCallbackProc) okCB, (XtPointer) ok_client_data );
    XtAddCallback( w, XmNokCallback,
                   (XtCallbackProc) removeCB, (XtPointer) w );
  } else {
    XtAddCallback( w, XmNokCallback,
                   (XtCallbackProc) removeCB, (XtPointer) w );
  }

  XtManageChild( w );


  return( w );

} /* xitCreatePixmapDialog */


/*----------------------------------------------------------------------*/

static void
  removeCB( Widget               widget,
            Widget               toplevel_widget,
            XmAnyCallbackStruct  *call_data )
{

  /* Code. */

  XtDestroyWidget( toplevel_widget );

  return;

} /* removeCB */
