/*----------------------------------------------------------------------------
--
--  Module:           xitIsTxEmpty
--
--  Project:          xit  - X Internal Toolkit
--  System:           xit  - X Internal Toolkit
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Check is a text widget is empty.
--
--  Filename:         xitIsTxEmpty.c
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-10-20
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
static char SCCSID[] = "@(#) Module: xitIsTxEmpty.c, Version: 1.1, Date: 95/02/18 15:10:40";


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <stdio.h>
#include <string.h>

#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>
#include <Xm/Text.h>

#include "System.h"

#include "xitTools.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

Boolean
  xitIsTextEmpty( Widget  widget )
{

  /* Variables. */
  char  *buffer_ref;


  /* Code. */

  buffer_ref = xitStringGetText( widget );

  if( buffer_ref == NULL || strlen( buffer_ref ) > 0 ) {
    SysFree( buffer_ref );

    return( False );
  }

  SysFree( buffer_ref );


  return( True );

} /* xitIsTextEmpty */
