/*----------------------------------------------------------------------------
--
--  Module:           xitFieldSelect
--
--  Project:          xit   - X Internal Toolkit
--  System:           <>
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface for module xitFieldSelect.
--
--  Filename:         xitFieldSel.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-09-03
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xitFieldSel.h, Version: 1.1, Date: 95/02/18 15:10:30 */


/* Only include this module once. */
#ifndef define_xitFieldSelect_h
#  define define_xitFieldSelect_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

/* New resource names. */
#define FIELD_SELECT_CLASS  "FieldSelect"

#define XmNbgItems          "bgItems"
#define XmCBgItems          "BgItems"

#define XmNfgItems          "ggItems"
#define XmCFgItems          "FgItems"

#define XmNisVisible        "isVisible"
#define XmCIsVisible        "IsVisible"

#define XmNmodeAppend       "modeAppend"
#define XmCModeAppend       "ModeAppend"



/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Definition of callback structure. */
typedef struct {
  int     reason;
  XEvent  *event;
  char    *value;
} xitFieldSelectCallbackStruct;

/* The various child widgets you can get. */
typedef enum {
  xitFIELD_SELECT_TEXT_FIELD,
  xitFIELD_SELECT_BUTTON
} xitFieldSelectChildren;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

Widget
  xitCreateFieldSelect( Widget          parent,
                        String          name,
                        ArgList         add_args,
                        Cardinal        num_args,
                        XtCallbackProc  proc,
                        XtPointer       client_data );

void
  xitFieldSelectEditable( Widget   widget,
                          Boolean  editable );

Widget
  xitFieldSelectGetChild( Widget                  widget,
                          xitFieldSelectChildren  child );

void
  xitFieldSelectGetCurrent( Widget  widget,
                            char    **value_return );

Boolean
  xitFieldSelectGetIndex( Widget  widget,
                          int     *selected_index );

void
  xitFieldSelectSetAppend( Widget   widget,
                           Boolean  mode );

void
  xitFieldSelectSetCurrent( Widget   widget,
                            char     *new_value,
                            Boolean  call );

void
  xitFieldSelectSetEditable( Widget   widget,
                             Boolean  editable );

void
  xitFieldSelectSetIndex( Widget   widget,
                          int      set_index,
                          Boolean  call );

void
  xitFieldSelectSetMenu( Widget  widget,
                         char    *new_menu[],
                         int     elements );

void
  xitFieldSelectSetLength( Widget  widget,
                           int     max_length );

#endif
