/*----------------------------------------------------------------------------
--
--  Module:           xitCreTxt
--
--  Project:          xit  - X Internal Toolkit
--  System:           xit  - X Internal Toolkit
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Creates a text widget.
--
--  Filename:         xitCreTxt.c
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-10-20
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
static char SCCSID[] = "@(#) Module: xitCreTxt.c, Version: 1.1, Date: 95/02/18 15:10:27";


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <stdio.h>

#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/IntrinsicP.h>

#include <Xm/Xm.h>
#include <Xm/Text.h>

#include "xitTools.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

Widget 
  xitCreateText( Widget           parent, 
                 XIT_TEXT_STRUCT  *edits )
{

  /* Variables. */
  Widget  widget;


  /* Code. */

  widget = xitCreateTextCols( parent, edits, 0 );


  return( widget );

} /* xitCreateText */


/*----------------------------------------------------------------------*/

Widget 
  xitCreateTextCols( Widget           parent, 
                     XIT_TEXT_STRUCT  *edits,
                     int              init_cols )
{

  /* Variables. */
  Arg        args[ 10 ];
  Cardinal   n;
  Widget     widget;


  /* Code. */

  n = 0;

  if( edits -> lines > 1 ) {
    XtSetArg( args[ n ], XmNeditMode, XmMULTI_LINE_EDIT ); n++;
  }       

  if( init_cols > 0 ) {
    XtSetArg( args[ n ], XmNcolumns, (short) init_cols ); n++;
  }       

  XtSetArg( args[ n ], XmNeditable, edits -> editable ); n++;

  widget = XmCreateText( parent, edits -> name, args, n );

  if( edits -> callback != NULL )
    XtAddCallback( widget, XmNactivateCallback,
                   edits -> callback, edits -> name );


  return( widget );

} /* xitCreateTextCols */


/*----------------------------------------------------------------------*/

Widget 
  xitCreateTextScrolled( Widget           parent, 
                         XIT_TEXT_STRUCT  *edits )
{

  /* Variables. */
  Widget  widget;


  /* Code. */

  widget = xitCreateTextScrolledCols( parent, edits, 0 );


  return( widget );

} /* xitCreateTextScrolled */


/*----------------------------------------------------------------------*/

Widget 
  xitCreateTextScrolledCols( Widget           parent, 
                             XIT_TEXT_STRUCT  *edits,
                             int              init_cols )
{

  /* Variables. */
  Arg        args[ 10 ];
  Cardinal   n;
  Widget     widget;


  /* Code. */

  n = 0;

  if( edits -> lines > 1 ) {
    XtSetArg( args[ n ], XmNeditMode, XmMULTI_LINE_EDIT ); n++;
  }       

  if( init_cols > 0 ) {
    XtSetArg( args[ n ], XmNcolumns, (short) init_cols ); n++;
  }       

  XtSetArg( args[ n ], XmNeditable, edits -> editable ); n++;

  widget = XmCreateScrolledText( parent, edits -> name, args, n );

  if( edits -> callback != NULL )
    XtAddCallback( widget, XmNactivateCallback,
                   edits -> callback, edits -> name );


  return( widget );

} /* xitCreateTextScrolledCols */
