/*----------------------------------------------------------------------------
--
--  Module:           xitCreArrPu
--
--  Project:          xit  - X Internal Toolkit
--  System:           xit  - X Internal Toolkit
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Creates an arrow push button.
--
--  Filename:         xitCreArrPu.c
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-10-20
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
static char SCCSID[] = "@(#) Module: xitCreArrPu.c, Version: 1.1, Date: 95/02/18 15:10:22";


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>
#include <Xm/ArrowB.h>

#include "xitTools.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

Widget 
  xitCreateArrowPushButton( Widget            parent, 
                            XIT_ARROW_STRUCT  *pb )
{

  /* Variables. */
  Arg        args[ 5 ];
  Cardinal   n;
  Widget     w;


  /* Code. */

  n = 0;

  XtSetArg( args[ n ], XmNarrowDirection, pb -> direction ); n++;

  if( ! pb -> sensitive ) {
    XtSetArg( args[ n ], XmNsensitive, False ); n++;
  }

  w = XmCreateArrowButton( parent, pb -> name, args, n );

  if( pb -> callback != NULL ) 
    XtAddCallback( w, XmNactivateCallback, pb -> callback, pb -> name );


  return( w );

} /* xitCreateArrowPushButton */
