/*----------------------------------------------------------------------------
--
--  Module:           xitClipboard
--
--  Project:          xit  - X Internal Toolkit
--  System:           xit  - X Internal Toolkit
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for module xitClipboard.c.
--
--  Filename:         xitClipboard.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-05-05
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xitClipboard.h, Version: 1.1, Date: 95/02/18 15:10:20 */


/* Only include this module once. */
#ifndef define_xitClipboard_h
#  define define_xitClipboard_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

/* Identifiers. */
#define XIT_CL_PRIMARY      0
#define XIT_CL_SECONDARY    1
#define XIT_CL_CLIPBOARD    2
#define XIT_CL_XBUFFER      3

#define XIT_CL_CUT          0
#define XIT_CL_COPY         1
#define XIT_CL_PASTE        2

#define XIT_CL_UNDEFINED    1000

/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Callback functions to retrieve/insert data to/from the clipboard. */
typedef void
  ( *XIT_CL_RETRIEVE_CB_TYPE ) (char **value, void *client_data);

typedef void
  ( *XIT_CL_INSERT_CB_TYPE ) (char *value, void *client_data);

/* Each selection contains three actions. */
typedef struct {
  Widget  button;
  Widget  actionButton[ 3 ];
} XIT_CL_SELECTION;

/* The necessary data for the clipboard selection. */
typedef struct {
  char                     *selection_text[ 4 ];
  char                     *action_text[ 3 ];
  XIT_CL_RETRIEVE_CB_TYPE  retrieveCB;
  XIT_CL_INSERT_CB_TYPE    insertCB;

  /* These items should not be set/changed. */
  Widget            popup;
  void              *client_data;
  XIT_CL_SELECTION  selection[ 4 ];
} XIT_CL_RECORD, *XIT_CL_RECORD_REF;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

void
  xitClCreateMenu( Widget             parent,
                   XIT_CL_RECORD_REF  record );

void
  xitClDestroy( XIT_CL_RECORD_REF  *record );

XIT_CL_RECORD_REF
  xitClInitialize( void );

void
  xitClPostMenu( XIT_CL_RECORD_REF  record,
                 void               *client_data,
                 XEvent             *event );

#endif
