/*----------------------------------------------------------------------------
--
--  Module:           XmUbTimeBox
--
--  Project:          XmUb - Ulle's Motif widgets
--  System:           
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    This is the private header file for the widget.
--
--  Filename:         XmUbTimeBP.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1993-09-12
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: XmUbTimeBP.h, Version: 1.1, Date: 95/02/18 15:10:16 */

#ifndef _XmUbTimeBP_h
#define _XmUbTimeBP_h

/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <stdio.h>
#include <X11/StringDefs.h>
#include <Xm/XmP.h>

#if XmVersion > 1001
#include "Xm/ManagerP.h"
#endif

#include "XmUbTimeB.h"

/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

/* Indices for widgets in the internal children array. */

#define NO_INTERNAL_CHILDREN  ( XmUbTB_LAST_CHILD + 1 )

/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


typedef unsigned char  menuPositionType;
typedef int            widgetFormatType;


/* CLASS RECORD */

typedef struct {

  /* This function is called with the text field widget id (child of time box)
     and should pop up a dialog for selecting a time. */
  XtWidgetProc  popup_time_selection;

  /* This function is called with the text field widget id (child of time box)
     and should pop up a dialog for selecting a date. */
  XtWidgetProc  popup_date_selection;

  XtPointer     extension;

} XmUbTimeBoxClassPart;


/* Full class record declaration. */

typedef struct {

  CoreClassPart          core_class;
  CompositeClassPart     composite_class;
  ConstraintClassPart    constraint_class;
  XmManagerClassPart     manager_class;
  XmUbTimeBoxClassPart   timebox_class;

} XmUbTimeBoxClassRec;


/* INSTANCE RECORD */

typedef struct {

  /* RESOURCES. */
  /* Callbacks. */
  XtCallbackList    activate_callback;
  XtCallbackList    completion_callback;
  XtCallbackList    popup_selection_callback;
  XtCallbackList    value_changed_callback;

  /* Popup shells for date and time selection. */
  String            time_selection_title;
  String            date_selection_title;
  XmString          ok_label;
  XmString          cancel_label;
  XmString          year_label;
  XmString          month_label;
  XmString          week_label;

  /* Offsets and spacings. */
  Dimension         menu_spacing;
  Dimension         field_spacing;
  Dimension         range_spacing;
  Dimension         margin_height;
  Dimension         margin_width;

  /* Characters for keyword scanning. */
  char              *year_marker;
  char              *month_marker;
  char              *week_marker;
  char              *day_marker;
  char              *hour_marker;
  char              *minute_marker;

  /* Internal widget creation. */
  /* None of these resources may be changed after creation. */
  widgetFormatType  widget_format;
  Boolean           menu_enabled;
  XmUbMenuItemRef   menu_items;
  int               num_menu_items;
  XmString          menu_label;
  Pixmap            menu_pixmap;

  /* Layout. */
  /* None of these resources may be changed after creation. */
  unsigned char     orientation;
  Boolean           component_together;
  menuPositionType  menu_position;
  Boolean           destroy_dialogs;

  /* PRIVATE STATE. */
  /* Internal widgets. Some may be NULL depending on format. */
  Widget    internal_children[ NO_INTERNAL_CHILDREN ];

  Widget    time_selection_popup;
  Widget    date_selection_popup;

  int       field_for_time_selection;
  int       field_for_date_selection;

  Boolean   resize_called;  /* Because unclear widget set philosophy. */
  Boolean   internal_widgets_created;

  
} XmUbTimeBoxPart;

/* Full instance record declaration. */

typedef struct _XmUbTimeBoxRec {

  CorePart          core;
  CompositePart     composite;
  ConstraintPart    constraint;
  XmManagerPart     manager;
  XmUbTimeBoxPart   tbox;

} XmUbTimeBoxRec;



/* Constraint record for the children of this widget. */
typedef struct {

  XtPointer  extension;

} XmUbTimeBoxConstraintsPart;


typedef struct {

  XmManagerConstraintPart      manager;
  XmUbTimeBoxConstraintsPart   tbox;

} XmUbTimeBoxConstraintsRec, *XmUbTimeBoxConstraints;

/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/

/* Conventional declaration. */
extern XmUbTimeBoxClassRec xmUbTimeBoxClassRec;

/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

#endif
