/*----------------------------------------------------------------------------
--
--  Module:           Scramble
--
--  Project:          Tools - General C objects.
--  System:           Scr - Scramble text
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Makes easy to read text a bit more difficult to understand.
--
--  Filename:         Scramble.c
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1993-09-20
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
static char SCCSID[] = "@(#) Module: Scramble.c, Version: 1.1, Date: 95/02/18 14:32:29";


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "Standard.h"
#include "System.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/

/* Name of module. */
static char  *module_name = "Scramble";

/* Variables used during encryption. */
static int   pwd_length;
static int   pwd_ptr;
static char  *password_base = "String too long!";
static char  password[ 256 ];


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

static void
  cryptStep( char *buffer );

static void
  cryptString( char  *user_password,
               char  *buffer );

static void
  numStringToString( char  *num_string,
                     char  *string,
                     int   *string_length );

static void
  stringToNumString( char  *string,
                     int   string_length,
                     char  *num_string );


/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

void
  ScrDecryptFromNumString( char  *user_password,
                           char  *num_string,
                           char  *string )
{

  /* Variables. */
  int   length;
  char  *crypt_string;


  /* Code. */

  crypt_string = SysNewString( num_string );

  numStringToString( num_string, crypt_string, &length );
  cryptString( user_password, crypt_string );

  strcpy( string, (char *) crypt_string );
  *(string + length) = '\0';

  SysFree( crypt_string );


  return;

} /* ScrDecryptFromNumString */


/*----------------------------------------------------------------------*/

void
  ScrEncryptToNumString( char  *user_password,
                         char  *string,
                         char  *num_string )
{

  /* Variables. */
  int   length;
  char  *crypt_string;


  /* Code. */

  length       = strlen( string );
  crypt_string = SysNewString( string );

  cryptString( user_password, crypt_string );
  stringToNumString( crypt_string, length, num_string );

  SysFree( crypt_string );


  return;

} /* ScrEncryptToNumString */


/*----------------------------------------------------------------------*/

static void
  numStringToString( char  *num_string,
                     char  *string,
                     int   *string_length )
{

  /* Variables. */
  int   char_read;
  int   items;
  int   length;
  char  *num_string_ref;

  unsigned int  value;


  /* Code. */

  length         = 0;
  num_string_ref = num_string;

  do {
    if( *num_string_ref == '\0' )
      break;

    char_read = strlen( num_string_ref );
    items = sscanf( num_string_ref, "%03u%n", &value, &char_read );
    if( items != 1 )
      break;

    *(string + length) = (char) value;
    length++;

    num_string_ref = num_string_ref + char_read;
  } while( True );

  *string_length = length;


  return;

} /* numStringToString */


/*----------------------------------------------------------------------*/

static void
  stringToNumString( char  *string,
                     int   string_length,
                     char  *num_string )
{

  /* Variables. */
  int            index;
  unsigned int   value;
  unsigned char  char_value;
  char           buffer[ 50 ];


  /* Code. */

  *num_string = '\0';

  for( index = 0; index < string_length; index++ ) {
    char_value = (unsigned char) *(string + index);
    value      = (unsigned int) char_value;

    sprintf( buffer, "%03u", value );
    strcat( num_string, buffer );
  }


  return;

} /* stringToNumString */


/*----------------------------------------------------------------------*/

static void
  cryptString( char  *user_password,
               char  *buffer )
{

  /* Variables. */
  char  *char_ref;


  /* Code. */

  if( user_password != NULL )
    strcpy( password, user_password );
  else
    strcpy( password, password_base );

  pwd_length = strlen( password );
  pwd_ptr    = 0;

  char_ref = buffer;
  while( *char_ref != '\0' ) {
    cryptStep( char_ref );
    char_ref++;
  }


  return;

} /* cryptString */


/*----------------------------------------------------------------------*/

static void
  cryptStep( char *buffer )
{

  /* Variables. */
  char  salt_char;


  /* Code. */

  *buffer = *buffer ^ password[ pwd_ptr ] ^ (password[ 0 ] * pwd_ptr);

  if( pwd_ptr < (pwd_length - 1) )
    salt_char = password[ pwd_ptr + 1 ];
  else
    salt_char = password[ 0 ];

  password[ pwd_ptr ] = password[ pwd_ptr ] + salt_char;

  if( password[ pwd_ptr ] == '\0' )
    password[ pwd_ptr ] = password[ pwd_ptr ] + 1;

  pwd_ptr++;

  if( pwd_ptr >= pwd_length )
    pwd_ptr = 0;


  return;

} /* cryptStep */



