/*----------------------------------------------------------------------------
--
--  Module:           Message
--
--  Project:          Tools - General C objects.
--  System:           Msg - Message catalogue
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface for module Message.
--
--  Filename:         Message.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-03-14
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: Message.h, Version: 1.1, Date: 95/02/18 14:32:29 */


/* Include only once. */
#ifndef Message_h
#  define Message_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

#define  MSG_MAX_DOMAINS   100


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

Boolean
  msgAddFileTextDomain( char  *domain_name,
                        char  *msg_file );

Boolean
  msgAddTextDomain( char  *domain_name,
                    char  **message_index );

char
  *msgDGetText( char  *domain_name,
                int   message_id );

char
  *msgGetText( int  message_id );

void
  msgInitialize();

Boolean
  msgInitCatalogue( char  *text_domain,
                    char  *directory,
                    char  *language,
                    char  **default_msgs );

char
  *msgTextDomain( char  *domain_name );

#endif
