/*----------------------------------------------------------------------------
--
--  Module:           xtmSchedPriv
--
--  Project:          Xdiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Private data for the xtmSchedule module(s).
--
--  Filename:         xtmSchedPriv.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-04-04
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmSchedPriv.h, Version: 1.1, Date: 95/02/18 15:52:45 */


/* Only include this module once. */
#ifndef define_xtmSchedPriv_h
#  define define_xtmSchedPriv_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "TimDate.h"

#include "xtmGlobal.h"
#include "xtmDbFilter.h"
#include "xtmDbInclude.h"
#include "xtmDbTools.h"
#include "xtmEditEntry.h"
#include "xtmNavCal.h"
#include "xtmOpenView.h"
#include "xtmPlan.h"
#include "xtmPrEntries.h"
#include "xtmRemote.h"
#include "xtmSelHidden.h"
#include "xtmShowToDo.h"
#include "xtmSchedMain.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

/* Internal animation flags. */
#define ANI_MOVE_COPY       (1<<0)
#define ANI_NEW_ENTRY       (1<<1)
#define ANI_NEW_DURATION    (1<<2)
#define ANI_NEW_ENTRY       (1<<1)

#define ANI_NOTE            (1<<6)
#define ANI_ENTRY           (1<<7)
#define ANI_TIME            (1<<8)

#define ANI_FIXED           (1<<10)
#define ANI_RUBBERBAND      (1<<11)
#define ANI_FIXED_HEIGHT    (1<<12)
#define ANI_FIXED_WIDTH     (1<<13)
#define ANI_PICK_DAY        (1<<14)

#define ANI_STARTED         (1<<16)


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* The different scale values. */
typedef enum {
  SCHED_DISP_DAYS,
  SCHED_DAY_WIDTH
} SCHED_SCALE_TYPE;

/* States for the entry cache. */
typedef enum { 
  IS_CACHED,
  IS_EMPTY,
  IS_NEW,
  IS_USED
} CACHE_STATE;


/* Forward declaration. */
typedef struct sched_rec  *SCHED_REC_REF;

/* Callback when the animation ends. */
typedef void ( *ANIMATION_ACTION_CB ) ( SCHED_REC_REF, XEvent * );

/* Callback when for entry popup menu. */
typedef void ( *ENTRY_POPUP_CB ) ( Widget, SCHED_REC_REF, XEvent * );


/* Record to use when we do animation. */
typedef struct {

  /* Are we doing animation? */
  Boolean  animate_on;

  /* Display the time when we move the entry? */
  Boolean  display_time;

  /* Flags for the animation. */
  UINT32  flags;

  /* Positions for the rectangle to move. */
  int  start_x;
  int  start_y;
  int  end_x;
  int  end_y;
  int  width;
  int  height;

  /* Grid to use when doing animation. */
  float  grid_minutes;

  /* Animation widgets. */
  Widget  animateW;
  Widget  aniEntryW;
  Widget  aniNoteW;
  Widget  aniTimeW;

  /* Things to do when the animation ends. */
  ANIMATION_ACTION_CB  actionCB;

  /* Start and entry time of entry while moving around. */
  TIM_TIME_REF  start_date;
  TIM_TIME_REF  start_time;
  int           duration;

  TIM_TIME_REF  old_start_date;
  TIM_TIME_REF  old_start_time;
  int           old_duration;

} ANIMATE_REC, *ANIMATE_REC_REF;


/* Information about one entry in the schedule. */
typedef struct {
  Boolean                found;
  Boolean                selected;
  int                    duration;
  int                    uid;
  UINT32                 flags;
  UINT32                 id;
  char                   db_name[ XTM_GL_MAX_CAL_NAME + 1 ];
  char                   *entry_text;
  Widget                 noteW;
  Widget                 appW;
  Widget                 appMarkW;
  CACHE_STATE            cache_state;
  TIM_TIME_REF           date_stamp;
  TIM_TIME_REF           time_stamp;
  XTM_DB_ENTRY_TYPE      type;
  XTM_DB_ENTRY_CATEGORY  category;
} ENTRY_INFO, *ENTRY_INFO_REF;


/* Cache for entries in the schedule. */
typedef struct {
  int             max_used;
  ENTRY_INFO_REF  *used;
} ENTRY_CACHE, *ENTRY_CACHE_REF;


/* Basic data structure for the XDschedule appliaction. */
typedef struct sched_rec {

  /* Force update of the schedule. */
  Boolean  force_update;

  /* Counter to use when removing/creating widgets. */
  int  counter;

  /* Selected day. */
  int  day_selected;

  /* Delta in minutes between time ticks. */
  int  entry_delta;
  int  old_entry_delta;

  /* Number of days to display in the schedule. */
  int  show_no_days;

  /* Various flags to use. */
  UINT32  flags;

  /* Id to use for update functions. */
  UINT32  update_id;

  /* We are working on this database. */
  char  db_name[ XTM_GL_MAX_CAL_NAME + 1 ];

  /* Name of database to use at startup. */
  char  *startup_db;

  /* Width of a single day name in header. */
  Dimension  day_width;

  /* Height of the time label. */
  Dimension  time_label_height;

  /* Height of a single line in the time label. */
  Dimension  time_line_height;

  /* Original background color for unselected entry. */
  Pixel  entry_saved_bg;

  /* Animation pixmaps. */
  int     tick_pixmap_index;
  Pixmap  tick_pixmap[ 7 ];

  /* Popup widget (and callback to call) in the day view. */
  Widget          entry_popupW;
  Widget          entry_text_popupW;
  ENTRY_POPUP_CB  entryAnimateHookCB;

  /* Save a selected entry here. */
  Widget  selected_widget;

  /* Schedule window. */
  Widget  scheduleW;

  /* Animation data. */
  ANIMATE_REC_REF  animate_ref;

  /* Cache for entries. */
  ENTRY_CACHE_REF  entry_cache_ref;

  /* Display schedule from this date. */
  TIM_TIME_REF  schedule_start;
  TIM_TIME_REF  old_schedule_start;

  /* Display schedule to this date. */
  TIM_TIME_REF  schedule_stop;
  TIM_TIME_REF  old_schedule_stop;

  /* Start display at this time. */
  TIM_TIME_REF  entry_start;
  TIM_TIME_REF  old_entry_start;

  /* Stop display at this time. */
  TIM_TIME_REF  entry_stop;
  TIM_TIME_REF  old_entry_stop;

  /* Include handle. */
  XTM_DI_HANDLE  include_handle;

  /* Filter record. */
  XTM_DM_FILTER_REC  filter_rec;

  /* Appointment editor reference. */
  XTM_ED_HANDLE  editor_handle;

  /* Filter handle. */
  XTM_FI_HANDLE  filter_handle;

  /* Select hidden entries. */
  XTM_SH_HANDLE  sel_hide_handle;

  /* Application wide resources. */
  XTM_GL_BASE_DATA_REF  appl_data_ref;

  /* Calendar reference. */
  XTM_NC_HANDLE  nav_cal_handle;

  /* Open view handle. */
  XTM_OV_HANDLE  open_handle;

  /* Planner handle. */
  XTM_PL_HANDLE  planner_handle;

  /* Printer reference. */
  XTM_PR_HANDLE  pr_handle;

  /* Remote up/download. */
  XTM_RT_HANDLE  remote_handle;

  /* Summary reference. */
  XTM_SD_HANDLE  show_handle;

  /* Callback to inform our creator of specific actions. */
  void              *user_data;
  XTM_SM_ACTION_CB  actionCB;

} SCHED_REC;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/


#endif
