/*----------------------------------------------------------------------------
--
--  Module:           xtmResource
--
--  Project:          XDiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Handle X-Window resource customization.
--
--  Filename:         xtmResource.c
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-12-02
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
static char SCCSID[] = "@(#) Module: xtmResource.c, Version: 1.1, Date: 95/02/18 15:52:42";


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>

#include "System.h"
#include "Message.h"
#include "TimDate.h"

#include "msgXdiary.h"
#include "xtmGlobal.h"
#include "xtmCustRes.h"
#include "xtmTags.h"
#include "xtmTools.h"
#include "xitError.h"
#include "xtmResource.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/

/* Name of module. */
static char  *module_name = "xtmResource";


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

static void
  buildColorArray( Widget  widget,
                   char    *color_list,
                   int     *no_colors,
                   Pixel   *colors,
                   int     max_colors );

static int
  noCaseStrcmp( char  *buffer1,
                char  *buffer2 );



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

void
  xtmRsFetchCustomResources( XTM_GL_CUSTOM_DATA_REF  custom_data_ref,
                             Widget                  parent )
{

  /* Variables. */
  int   index;
  char  **expand_files[ 50 ];
  char  *file_ref;
  

  /* Code. */

  XtGetApplicationResources( parent, (XtPointer) custom_data_ref, 
                             customize_resources, 
                             XtNumber( customize_resources ), 
                             NULL, 0 );


  /* Are we using UNIX week numbers? */
  if( custom_data_ref -> std_unix_week_numbers )
    TimSetUnixWeekNo( True );


  /* Expand any directory and filename references. */
  expand_files[  0 ] = &custom_data_ref -> acl_script;
  expand_files[  1 ] = &custom_data_ref -> alarm_script;
  expand_files[  2 ] = &custom_data_ref -> custom_script;
  expand_files[  3 ] = &custom_data_ref -> find_location_script;
  expand_files[  4 ] = &custom_data_ref -> print_script;
  expand_files[  5 ] = &custom_data_ref -> system_printer_file;
  expand_files[  6 ] = &custom_data_ref -> tune_file[ 0 ];
  expand_files[  7 ] = &custom_data_ref -> tune_file[ 1 ];
  expand_files[  8 ] = &custom_data_ref -> tune_file[ 2 ];
  expand_files[  9 ] = &custom_data_ref -> tune_file[ 3 ];
  expand_files[ 10 ] = &custom_data_ref -> tune_file[ 4 ];
  expand_files[ 11 ] = &custom_data_ref -> user_printer_file;
  expand_files[ 12 ] = &custom_data_ref -> holidays_db_dir;
  expand_files[ 13 ] = &custom_data_ref -> error_log_file;
  expand_files[ 14 ] = &custom_data_ref -> db_selection_dir;
  expand_files[ 15 ] = &custom_data_ref -> custom_file;
  expand_files[ 16 ] = NULL;

  index = 0;
  do {
    if( expand_files[ index ] == NULL )
      break;

    file_ref = SysExpandFilename( *(expand_files[ index ]) );
    *expand_files[ index ] = file_ref;

    index++;
  } while( True );


  return;

} /* xtmRsFetchCustomResources */


/*----------------------------------------------------------------------*/

void
  xtmRsFetchColors( XTM_GL_CUSTOM_DATA_REF  custom_data_ref,
                    Widget                  parent )
{

  /* Code. */

  /* Build colors. */
  buildColorArray( parent,
                   custom_data_ref  -> db_color_bg_list,
                   &custom_data_ref -> db_colors_bg.no_colors,
                   custom_data_ref  -> db_colors_bg.color,
                   SysNumber( custom_data_ref -> db_colors_bg.color ) );

  buildColorArray( parent,
                   custom_data_ref  -> color_bg_list,
                   &custom_data_ref -> colorsDB_bg.no_colors,
                   custom_data_ref  -> colorsDB_bg.color,
                   SysNumber( custom_data_ref -> colorsDB_bg.color ) );

  buildColorArray( parent,
                   custom_data_ref  -> color_fg_list,
                   &custom_data_ref -> colorsDB_fg.no_colors,
                   custom_data_ref  -> colorsDB_fg.color,
                   SysNumber( custom_data_ref -> colorsDB_fg.color ) );

  /* Fetch tags colors. */
  custom_data_ref -> tags_db = 
    xtmTgBuildTagDb( parent, custom_data_ref -> tags_colors );


  return;

} /* xtmRsFetchColors */


/*----------------------------------------------------------------------*/

static void
  buildColorArray( Widget  widget,
                   char    *color_list,
                   int     *no_colors,
                   Pixel   *colors,
                   int     max_colors )
{

  /* Variables. */
  Boolean  ok;
  int      char_read;
  int      index;
  int      items;
  char     buffer[ 250 ];
  char     color_string[ 100 ];
  char     *char_ref;
  Pixel    fetch_color;


  /* Code. */

  char_ref = color_list;
  index    = 0;

  /* Convert all color names to pixel values. */
  do {

    while( isspace( *char_ref ) )
      char_ref++;

    if( *char_ref == '\0' )
      break;

    char_read = strlen( char_ref );
    items = sscanf( char_ref, "%s%n", color_string, &char_read );
    if( items != 1 )
      break;

    ok = xitAllocNamedColor( widget, color_string, &fetch_color );
    if( ! ok ) {
      sprintf( buffer, msgGetText( MXDI_CUST_UNKNOWN_COLOR ), color_string );
      xitErMessage( NULL, XIT_ER_ERROR, module_name, "", buffer );
    } else {
      *(colors + index ) = fetch_color;
      index++;
    }

    char_ref = char_ref + char_read;

  } while( index < max_colors );

  *no_colors = index;


  return;

} /* buildColorArray */


/*----------------------------------------------------------------------*/

static int
  noCaseStrcmp( char  *buffer1,
                char  *buffer2 )
{

  /* Variables. */
  char  *char_ref1;
  char  *char_ref2;


  /* Code. */

  if( strlen( buffer1 ) != strlen( buffer2 ) )
    return( strcmp( buffer1, buffer2 ) );

  char_ref1 = buffer1;
  char_ref2 = buffer2;

  while( *char_ref1 != '\0' ) {
    if( tolower( *char_ref1 ) < tolower( *char_ref2 ) )
      return( -1 );
    else if( tolower( *char_ref1 ) > tolower( *char_ref2 ) )
      return( 1 );

    char_ref1++;
    char_ref2++;
  }

  return( 0 );

} /* noCaseStrcmp */
