/*----------------------------------------------------------------------------
--
--  Module:           xtmMsgSend
--
--  Project:          Xdiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for module xtmMsgSend.
--
--  Filename:         xtmMsgSend.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-04-01
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmMsgSend.h, Version: 1.1, Date: 95/02/18 15:52:35 */


/* Include this module only once. */
#ifndef define_xtmMsgSend_h
#  define define_xtmMsgSend_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "xtmGlobal.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Handle to use when comminucating with the reader. */
typedef  void  *XTM_MS_HANDLE;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

void
  xtmMsDestroy( XTM_MS_HANDLE  send_handle );

XTM_MS_HANDLE
  xtmMsInitialize( XTM_GL_BASE_DATA_REF  appl_data_ref,
                   Widget                parent );

void
  xtmMsSendMessage( XTM_MS_HANDLE  send_handle,
                    char           *db_name,
                    UINT32         id );

void
  xtmMsSetRecipients( XTM_MS_HANDLE  send_handle,
                      char           *msg_to[],
                      int            msg_to_no );

void
  xtmMsSetToDate( XTM_MS_HANDLE  send_handle,
                  TIM_TIME_REF   to_date );

#endif
