/*----------------------------------------------------------------------------
--
--  Module:           xtmLocate
--
--  Project:          XDiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Locate a calendar.
--
--  Filename:         xtmLocate.c
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-10-27
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
static char SCCSID[] = "@(#) Module: xtmLocate.c, Version: 1.1, Date: 95/02/18 15:52:26";


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <X11/Intrinsic.h>
#include <X11/cursorfont.h>

#include <Xm/Xm.h>

#include "System.h"
#include "Message.h"

#include "msgXdiary.h"
#include "xitError.h"
#include "xtmLocate.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/

/* Name of module. */
static char  *module_name = "xtmLocate";


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

Boolean
  xtmLcLocateCalendar( Widget  parent,
                       char    *calendar,
                       char    *locate_script,
                       char    *result,
                       int     max_result )
{

  /* Variables. */
  int      status;
  char     buffer[ 500 ];
  char     *char_ref;
  Cursor   wait_cursor;
  Display  *display = NULL;
  Window   window = None;
  FILE     *pipe_ref;


  /* Code. */

  *result = '\0';

  if( parent != NULL ) {
    display = XtDisplay( parent );
    window  = XtWindow(  parent );
  }


  /* Does the executable file exist? */
  status = access( locate_script, (R_OK | X_OK) );

  if( status != 0 ) {
    xitErMessage( parent, XIT_ER_ERROR,
                  module_name, "xtmLcLocateCalendar",
                  msgGetText( MXDI_PROCESS_NO_FILE ) );
    return( False );
  }


  /* Waiting cursor. */
  if( parent != NULL ) {
    wait_cursor = XCreateFontCursor( display, XC_watch );
    XDefineCursor( display, window, wait_cursor );

    XFlush( display );
  }


  /* The search command. */
  char_ref = (char *) SysMalloc( strlen( locate_script ) + 
                                 strlen( calendar ) + 50 );

  sprintf( char_ref, "%s %s", locate_script, calendar );


  /* Open a pipe to the locate procedure. */
  pipe_ref = (FILE *) popen( char_ref, "r" );
  SysFree( char_ref );

  if( pipe_ref == NULL ) {
    xitErMessage( parent, XIT_ER_ERROR,
                  module_name, "xtmLcLocateCalendar",
                  msgGetText( MXDI_PROCESS_CANNOT_FORK ) );

    return( False );
  }


  /* Wait for the result (a single line). If empty, not found. */
  char_ref = fgets( buffer, sizeof( buffer ), pipe_ref );

  /* Close the pipe. */
#ifdef XD_HAS_NO_WAITPID
  fclose( pipe_ref );
#else
  pclose( pipe_ref );
#endif

  /* Restore cursor. */
  if( parent != NULL )
    XUndefineCursor( display, window );


  /* Check the result. */
  if( char_ref == NULL )
    return( False );

  buffer[ strlen( buffer ) -1 ] = '\0';
  strncpy( result, buffer, max_result );
  *(result + max_result - 1) = '\0';


  return( True );

} /* xtmLcLocateCalendar */
