/*----------------------------------------------------------------------------
--
--  Module:           xtmGroupDb
--
--  Project:          XDiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for module xtmGroupDb.
--
--  Filename:         xtmGroupDb.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1993-02-08
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmGroupDb.h, Version: 1.1, Date: 95/02/18 15:52:23 */


/* Include this file only once. */
#ifndef define_xtmGroupDb_h
#  define define_xtmGroupDb_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

/* Max length of a group name. */
#define XTM_GD_MAX_GROUP_NAME   15

/* Flags for a group entry. */
#define XTM_GD_FLAG_IS_INCLUDED         (1<<0)


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Handle to use when comminucating with the group db. */
typedef  void  *XTM_GD_HANDLE;


/* Group description. */
typedef struct {

  /* Flags. */
  UINT32  flags;

  /* Group name. */
  char  name[ XTM_GD_MAX_GROUP_NAME + 1 ];

  /* Group members. */
  char  *members;

} XTM_GD_ENTRY, *XTM_GD_ENTRY_REF;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

Boolean
  xtmGdAddEntry( XTM_GD_HANDLE     group_handle,
                 char              *name,
                 XTM_GD_ENTRY_REF  group_ref );

Boolean
  xtmGdChangeEntry( XTM_GD_HANDLE     group_handle,
                    char              *name,
                    XTM_GD_ENTRY_REF  group_ref );

XTM_GD_HANDLE
  xtmGdCopyGroups( XTM_GD_HANDLE  group_handle );

Boolean
  xtmGdDeleteEntry( XTM_GD_HANDLE  group_handle,
                    char           *group_name );

Boolean
  xtmGdFetchGroupNames( XTM_GD_HANDLE  group_handle,
                        char           **group_names );

Boolean
  xtmGdFetchNamedGroup( XTM_GD_HANDLE     group_handle,
                        char              *group_name,
                        XTM_GD_ENTRY_REF  return_group_ref );

void
  xtmGdFree( XTM_GD_HANDLE  group_handle );

XTM_GD_HANDLE
  xtmGdInitialize();


#endif
