/*----------------------------------------------------------------------------
--
--  Module:           xtmCustRes
--
--  Project:          XDiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Definition of the customize record for all XDiary applications.
--
--  Filename:         xtmCustRes.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-04-01
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmCustRes.h, Version: 1.1, Date: 95/02/18 15:52:06 */


/* Include this file only once. */
#ifndef define_xtmCustResource_h
#  define define_xtmCustResource_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/

/* The customize resource record. */
static XtResource  customize_resources[] = {

  { "aclScript", "AclScript", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, acl_script ), 
    XtRString, "xdaclunix" },

  { "actionAlarmMarker", "ActionAlarmMarker", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, action_alarm_marker ), 
    XtRString, "161" },

  { "afsVfsId", "AfsVfsId", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, afs_vfs_id ), 
    XtRString, "4" },

  { "alarm1Valid", "Alarm1Valid", XtRBoolean, sizeof( Boolean ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, alarm_valid[ 0 ] ), 
    XtRString, "True" },

  { "alarm1Offset", "Alarm1Offset", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, alarm_offset[ 0 ] ), 
    XtRString, "-10" },

  { "alarm2Valid", "Alarm2Valid", XtRBoolean, sizeof( Boolean ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, alarm_valid[ 1 ] ), 
    XtRString, "True" },

  { "alarm2Offset", "Alarm2Offset", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, alarm_offset[ 1 ] ), 
    XtRString, "-5" },

  { "alarm3Valid", "Alarm3Valid", XtRBoolean, sizeof( Boolean ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, alarm_valid[ 2 ] ), 
    XtRString, "True" },

  { "alarm3Offset", "Alarm3Offset", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, alarm_offset[ 2 ] ), 
    XtRString, "0" },

  { "alarm4Valid", "Alarm4Valid", XtRBoolean, sizeof( Boolean ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, alarm_valid[ 3 ] ), 
    XtRString, "False" },

  { "alarm4Offset", "Alarm4Offset", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, alarm_offset[ 3 ] ), 
    XtRString, "0" },

  { "alarm5Valid", "Alarm5Valid", XtRBoolean, sizeof( Boolean ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, alarm_valid[ 4 ] ), 
    XtRString, "False" },

  { "alarm5Offset", "Alarm5Offset", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, alarm_offset[ 4 ] ), 
    XtRString, "0" },

  { "alarmMarker", "AlarmMarker", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, alarm_marker ), 
    XtRString, "182" },

  { "alarmScript", "AlarmScript", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, alarm_script ), 
    XtRString, "xdalarm" },

  { "alarmShowLines", "AlarmShowLines", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, alarm_show_lines ), 
    XtRString, "2" },

  { "alarmsForNewApp", "AlarmsForNewApp", XtRBoolean, sizeof( Boolean ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, alarm_for_new_app ), 
    XtRString, "True" },

  { "alarmVolume", "AlarmVolume", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, alarm_volume ), 
    XtRString, "25" },

  { "appointmentPaneHeight", "AppointmentPaneHeight", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, app_pane_height ), 
    XtRString, "330" },

  { "archiveMarker", "ArchiveMarker", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, archive_marker ), 
    XtRString, "97" },

  { "calDayButtonStyle", "CalDayButtonStyle", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, cal_button_style ), 
    XtRString, "2" },

  { "calEntryShadow", "CalEntryShadow", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, cal_entry_shadow ), 
    XtRString, "2" },

  { "calIconText", "CalIconText", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, cal_icon_text ), 
    XtRString, "time" },

  { "calMonthExtend", "CalMonthExtend", XtRBoolean, sizeof( Boolean ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, cal_month_extend ), 
    XtRString, "True" },

  { "clickDateNewView", "ClickDateNewView", XtRBoolean, sizeof( Boolean ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, click_date_new_view ), 
    XtRString, "False" },

  { "colorBgList", "ColorBgList", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, color_bg_list ), 
    XtRString, "Grey20 Grey40 Grey60 Grey80" },

  { "colorFgList", "ColorFgList", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, color_fg_list ), 
    XtRString, "Grey20 Grey40 Grey60 Grey80" },

  { "confirmActions", "ConfirmActions", XtRBoolean, sizeof( Boolean ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, confirm_actions ), 
    XtRString, "True" },

  { "customFile", "CustomFile", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, custom_file ), 
    XtRString, "" },

  { "customScript", "CustomScript", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, custom_script ), 
    XtRString, "xdcustom" },

  { "dateMarkBg", "DateMarkBg", XtRPixel, sizeof( Pixel ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, date_mark_bg ), 
    XtRString, "White" },

  { "dayViewDays", "DayViewDays", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, day_view_days ), 
    XtRString, "7" },

  { "dayViewDaySwitch", "DayViewDaySwitch", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, day_view_day_switch ), 
    XtRString, "1" },

  { "dbColorBgList", "DbColorBgList", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, db_color_bg_list ), 
    XtRString, "Grey20 Grey40 Grey60 Grey80" },

  { "dbSelectionDir", "DbSelectionDir", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, db_selection_dir ), 
    XtRString, "./" },

  { "debug", "Debug", XtRBoolean, sizeof( Boolean ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, debug_mode ), 
    XtRString, "False" },

  { "defaultDateFormat", "DefaultDateFormat", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, default_date_format ), 
    XtRString, "YMD-1111" },

  { "defaultDayWidth", "DefaultDayWidth", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, def_day_width ), 
    XtRString, "130" },

  { "defaultEntryDelta", "DefaultEntryDelta", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, default_entry_delta ), 
    XtRString, "60" },

  { "defaultEntryTag", "DefaultEntryTag", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, default_entry_tag ), 
    XtRString, "" },

  { "defaultEntryText", "DefaultEntryText", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, default_entry_text ), 
    XtRString, "" },

  { "defaultPrinter", "DefaultPrinter", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, default_printer ), 
    XtRString, "" },

  { "defaultPrinterType", "DefaultPrinterType", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, default_printer_type ), 
    XtRString, "PS" },

  { "defaultTimeFormat", "DefaultTimeFormat", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, default_time_format ), 
    XtRString, "24    :0" },

  { "defaultTune", "DefaultTune", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, default_tune ), 
    XtRString, "1" },

  { "displayEntryFlags", "DisplayEntryFlags", XtRBoolean, sizeof( Boolean ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, display_entry_flags ), 
    XtRString, "True" },

  { "doRefresh", "DoRefresh", XtRBoolean, sizeof( Boolean ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, do_refresh ), 
    XtRString, "True" },

  { "entriesInteractive", "EntriesInteractive", XtRBoolean, sizeof( Boolean ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, entries_interactive ), 
    XtRString, "True" },

  { "entryButUnselectBg", "EntryButUnselectBg", XtRPixel, sizeof( Pixel ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, entry_button_unselect_bg ), 
    XtRString, "White" },

  { "entryDefaultDuration", "EntryDefaultDuration", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, entry_default_duration ), 
    XtRString, "60" },

  { "entryExistFg", "EntryExistFg", XtRPixel, sizeof( Pixel ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, entry_exist_fg ), 
    XtRString, "Black" },

  { "entryIncludeBg", "EntryIncludeBg", XtRPixel, sizeof( Pixel ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, entry_include_bg ), 
    XtRString, "White" },

  { "entryImportantFg", "EntryImportantFg", XtRPixel, sizeof( Pixel ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, entry_important_fg ), 
    XtRString, "Black" },

  { "entryNormalFg", "EntryNormalFg", XtRPixel, sizeof( Pixel ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, entry_normal_fg ), 
    XtRString, "Black" },

  { "entryNoteFg", "EntryNoteFg", XtRPixel, sizeof( Pixel ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, entry_note_fg ), 
    XtRString, "Black" },

  { "entryPaneWidth", "EntryPaneWidth", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, entry_pane_width ), 
    XtRString, "765" },

  { "entrySelectBg", "EntrySelectBg", XtRPixel, sizeof( Pixel ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, entry_select_bg ), 
    XtRString, "White" },

  { "entryShadow", "EntryShadow", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, entry_shadow_thickness ), 
    XtRString, "0" },

  { "entryShowLines", "EntryShowLines", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, entry_show_lines ), 
    XtRString, "2" },

  { "entryTagsColors", "EntryTagsColors", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, tags_colors ), 
    XtRString, "" },

  { "entryTagsFilter", "EntryTagsFilter", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, entry_tags_filter ), 
    XtRString, "" },

  { "entryTagsMenu", "EntryTagsMenu", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, entry_tags_menu ), 
    XtRString, "Conf Imp Meet" },

  { "entryUnselectBg", "EntryUnselectBg", XtRPixel, sizeof( Pixel ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, entry_unselect_bg ), 
    XtRString, "White" },

  { "fancyCalendar", "FancyCalendar", XtRBoolean, sizeof( Boolean ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, cal_is_fancy ), 
    XtRString, "True" },

  { "filterAlarmTags", "FilterAlarmTags", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, filter_alarm_tags ), 
    XtRString, "" },

  { "errorLogFile", "ErrorLogFile", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, error_log_file ), 
    XtRString, "" },

  { "remoteScript", "RemoteScript", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, remote_script ), 
    XtRString, "xdremote" },

  { "filterDlTags", "FilterDlTags", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, filter_day_view_tags ), 
    XtRString, "" },

  { "findLocationScript", "FindLocationScript", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, find_location_script ), 
    XtRString, "xdlocation" },

  { "fridayFg", "FridayFg", XtRPixel, sizeof( Pixel ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, friday_fg ), 
    XtRString, "Black" },

  { "genPrintCmd", "GenPrintCmd", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, gen_print_command ), 
    XtRString, "lpr -P" },

  { "giveAlarm", "GiveAlarm", XtRBoolean, sizeof( Boolean ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, give_alarm ), 
    XtRString, "True" },

  { "holidayFg", "HolidayFg", XtRPixel, sizeof( Pixel ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, holiday_fg ), 
    XtRString, "Black" },

  { "holidaysDbDir", "HolidaysDbDir", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, holidays_db_dir ), 
    XtRString, "./" },

  { "includeMarker", "IncludeMarker", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, include_marker ), 
    XtRString, "187" },

  { "importantMarker", "ImportantMarker", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, important_marker ), 
    XtRString, "33" },

  { "layoutList", "LayoutList", XtRBoolean, sizeof( Boolean ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, list_layout ), 
    XtRString, "False" },

  { "listStartHour", "ListStartHour", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, start_hour ), 
    XtRString, "8" },

  { "listStopHour", "ListStopHour", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, stop_hour ), 
    XtRString, "18" },

  { "mondayFg", "MondayFg", XtRPixel, sizeof( Pixel ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, monday_fg ), 
    XtRString, "Black" },

  { "newRelease", "NewRelease", XtRBoolean, sizeof( Boolean ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, new_release ), 
    XtRString, "False" },

  { "notePaneHeight", "NotePaneHeight", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, note_pane_height ), 
    XtRString, "50" },

  { "noteDoneMarker", "NoteDoneMarker", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, note_done_marker ), 
    XtRString, "172" },

  { "noteNotDoneMarker", "NoteNotDoneMarker", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, note_not_done_marker ), 
    XtRString, "32" },

  { "paperSize", "PaperSize", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, default_paper_size ), 
    XtRString, "1" },

  { "printDefLines", "PrintDefLines", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, print_def_lines ), 
    XtRString, "2" },

  { "printDefSheets", "PrintDefSheets", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, print_def_sheets ), 
    XtRString, "0" },

  { "printIn3d", "PrintIn3d", XtRBoolean, sizeof( Boolean ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, pr_in_3d ), 
    XtRString, "True" },

  { "printScript", "PrintScript", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, print_script ), 
    XtRString, "" },

  { "printerTypes", "PrinterTypes", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, printer_types ), 
    XtRString, "PS Ascii" },

  { "printOnlyWorkdays", "PrintOnlyWorkdays", XtRBoolean, sizeof( Boolean ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, pr_only_workdays ), 
    XtRString, "False" },

  { "privateMarker", "PrivateMarker", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, private_marker ), 
    XtRString, "112" },

  { "promptRepeatWin", "PromptRepeatWin", XtRBoolean, sizeof( Boolean ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, prompt_repeat_win ), 
    XtRString, "True" },

  { "readOnlyMode", "ReadOnlyMode", XtRBoolean, sizeof( Boolean ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, read_only_mode ), 
    XtRString, "False" },

  { "refreshRate", "RefreshRate", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, refresh_rate ), 
    XtRString, "30" },

  { "saturdayFg", "SaturdayFg", XtRPixel, sizeof( Pixel ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, saturday_fg ), 
    XtRString, "Black" },

  { "showDayToDo", "ShowDayToDo", XtRBoolean, sizeof( Boolean ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, show_day_to_do ), 
    XtRString, "False" },

  { "showNavCal", "ShowNavCal", XtRBoolean, sizeof( Boolean ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, display_nav_cal ), 
    XtRString, "False" },

  { "showWeekNumbers", "ShowWeekNumbers", XtRBoolean, sizeof( Boolean ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, show_week_numbers ), 
    XtRString, "True" },

  { "showStandingInCal", "ShowStandingInCal", XtRBoolean, sizeof( Boolean ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, show_stand_in_cal ), 
    XtRString, "True" },

  { "standingMarker", "StandingMarker", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, standing_marker ), 
    XtRString, "164" },

  { "startDayViewOn", "StartDayViewOn", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, start_day_view_on ), 
    XtRString, "1" },

  { "stdUnixWeekNo", "StdUnixWeekNo", XtRBoolean, sizeof( Boolean ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, std_unix_week_numbers ), 
    XtRString, "False" },

  { "summaryDefLines", "SummaryDefLines", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, summary_def_lines ), 
    XtRString, "2" },

  { "sundayFg", "SundayFg", XtRPixel, sizeof( Pixel ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, sunday_fg ), 
    XtRString, "Black" },

  { "systemBooks", "SystemBooks", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, system_books ), 
    XtRString, "" },

  { "systemPrinterFile", "SystemPrinterFile", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, system_printer_file ), 
    XtRString, "" },

  { "textMarkerPos", "TextMarkerPos", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, text_marker_pos ), 
    XtRString, "0" },

  { "thursdayFg", "ThursdayFg", XtRPixel, sizeof( Pixel ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, thursday_fg ), 
    XtRString, "Black" },

  { "timeSelValues", "TimeSelValues", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, time_sel_values ), 
    XtRString, "" },

  { "todayBg", "TodayBg", XtRPixel, sizeof( Pixel ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, today_bg ), 
    XtRString, "White" },

  { "trueColorIncluded", "TrueColorIncluded", XtRBoolean, sizeof( Boolean ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, true_color_included ), 
    XtRString, "True" },

  { "tuesdayFg", "TuesdayFg", XtRPixel, sizeof( Pixel ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, tuesday_fg ), 
    XtRString, "Black" },

  { "tuneDurationDelta", "TuneDurationDelta", XtRInt, sizeof( int ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, tune_dur_delta ), 
    XtRString, "0" },

  { "tune1File", "Tune1File", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, tune_file[ 0 ] ), 
    XtRString, "" },

  { "tune2File", "Tune2File", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, tune_file[ 1 ] ), 
    XtRString, "" },

  { "tune3File", "Tune3File", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, tune_file[ 2 ] ), 
    XtRString, "" },

  { "tune4File", "Tune4File", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, tune_file[ 3 ] ), 
    XtRString, "" },

  { "tune5File", "Tune5File", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, tune_file[ 4 ] ), 
    XtRString, "" },

  { "tunePlayer", "TunePlayer", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, tune_player ), 
    XtRString, "" },

  { "tunePlayerParam", "TunePlayerParam", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, tune_player_param ), 
    XtRString, "" },

  { "useFileLock", "UseFileLock", XtRBoolean, sizeof( Boolean ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, use_file_lock ), 
    XtRString, "True" },

  { "userBooks", "UserBooks", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, user_books ), 
    XtRString, "" },

  { "userEditor", "UserEditor", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, user_editor ), 
    XtRString, "xterm -e vi %s" },

  { "userPrinterFile", "UserPrinterFile", XtRString, sizeof( String ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, user_printer_file ), 
    XtRString, "" },

  { "validResourceFile", "ValidResourceFile", XtRBoolean, sizeof( Boolean ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, valid_resource_file ), 
    XtRString, "False" },

  { "wednesdayFg", "WednesdayFg", XtRPixel, sizeof( Pixel ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, wednesday_fg ), 
    XtRString, "Black" },

  { "weekNumberFg", "WeekNumberFg", XtRPixel, sizeof( Pixel ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, week_number_fg ), 
    XtRString, "Black" },

  { "widgetCaching", "WidgetCaching", XtRBoolean, sizeof( Boolean ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, widget_caching ), 
    XtRString, "True" },

  { "wrapBug", "WrapBug", XtRBoolean, sizeof( Boolean ),
    XtOffset( XTM_GL_CUSTOM_DATA_REF, wrap_bug ), 
    XtRString, "False" },

};


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/


#endif
