/*----------------------------------------------------------------------------
--
--  Module:           xtmArchive
--
--  Project:          XDiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for module xtmArchive.
--
--  Filename:         xtmArchive.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-07-29
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmArchive.h, Version: 1.1, Date: 95/02/18 15:51:55 */


/* Include this file only once. */
#ifndef define_xtmArchive_h
#  define define_xtmArchive_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "xtmGlobal.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

/* Flags for an archive entry. */
#define XTM_AR_FLAG_IS_INCLUDED         (1<<0)


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Data structure describing name and file for one archive. */
typedef struct {

  /* Flags. */
  UINT32  flags;

  /* Name of the archive. */
  char  short_name[ XTM_GL_MAX_ARCH_NAME + 1 ];

  /* File name. */
  char  *file_name;

} XTM_AR_ARCHIVE_FILE;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

void 
  xtmArArchiveEntry( XTM_GL_BASE_DATA_REF  appl_data_ref,
                     Widget                parent,
                     char                  *db_name,
                     UINT32                entry_id );

#endif
