# Net status and toggle button client.  Tcl code for tkgoodstuff
# Mark Crimmins (markcrim@umich.edu)

# Some theft from tkppp by Eric Jeschke (jeschke@cs.indiana.edu)

####################### Various Variables ######################

#  ( You can override any of them in your ~/.tkgoodstuffrc )

# forget the text message (redundant given the image fiddling)?
setifunset Net_nolabel 0

# commands to open and close net link
setifunset Net_on           ppp-on
setifunset Net_off          ppp-off

 # seconds between normal checks
setifunset Net_check_interval   20
setifunset Net_check_offset   0
 # seconds between checks during post-toggle vigilance
setifunset Net_waitcheck_interval 2
 # seconds for post-command vigilance (worst case connect&auth time)
setifunset Net_wait_period    120 
 # ping own address to keep link from looking inactive to host
setifunset Net_auto_ping        1
 # . . . every this many seconds:
setifunset Net_ping_interval   120

setifunset Net_ping_command     {ping -c 1 $ipaddr}
setifunset Net_getstatuscommand "/sbin/ifconfig | grep ppp0"
setifunset Net_getaddresscommand {ifconfig | grep inet.\*P-t-P | sed s/inet.*r:// | sed s/P-t-P.\*//}

# These are the images that show the status of the Net link.
setifunset netup_image  $images/netup.$TKG_defformat
setifunset netdn_image  $images/netdn.$TKG_defformat
setifunset netwt_image  $images/netwt.$TKG_defformat

# Code to set up periodic processing
set TKG_async_map(Net_update) [list $Net_check_interval $Net_check_offset Net-stat]

# Initial settings
set Net_linkstatus    -1
set ipaddr "nonexistent"

proc Net_make_up_button {} {
    global netup_image labelsonly Net_window Net_nolabel Net_off Net-params
    TKGButton Net -mode netup -image netup_image -unixcmd $Net_off
    RecursiveBind [set Net-params(window)] <1> "+
        Net_off_stuff
    "
    if !$Net_nolabel { TKGButton Net -text "Net Up" }
}

proc Net_make_down_button {} {
    global netdn_image labelsonly Net_window Net_nolabel Net_on Net-params
    TKGButton Net -mode netdn -image netdn_image -unixcmd $Net_on
    RecursiveBind [set Net-params(window)] <1> "+
        Net_on_stuff
    "
    if !$Net_nolabel { TKGButton Net -text "Net Down" }
}

proc Net_make_wait_button {} {
    global netwt_image labelsonly Net_window Net_nolabel
    TKGButton Net -mode netwt -image netwt_image
    if !$Net_nolabel { TKGButton Net -text "wait" }
}

proc Net_setstatus {} {
    global Net_linkstatus ipaddr Clients TKGcounter
    global TKG_async_map Net_ping_interval Net_getaddresscommand
    global set PopImap_interval PopImap_offset TKGcounter
   
    if {!$Net_linkstatus} {
	catch "unset TKG_async_map(Net_ping)"
	Net_make_down_button
        set ipaddr "nonexistent"
    } else {
        # Get IP address for pinging
        catch {eval exec $Net_getaddresscommand} ipaddr
        set ipaddr [string trim $ipaddr " "]
	DEBUG "Net up: ipaddr is $ipaddr"
	set TKG_async_map(Net_ping) [list $Net_ping_interval [ expr $TKGcounter + $Net_ping_interval] Net_ping]
	Net_make_up_button    
	if { [lsearch $Clients PopImap] != -1 } {
	  set TKG_async_map(PopImap_pop) [list $PopImap_interval [ expr ( $TKGcounter + 1)] PopImap_do_pop]
	}
    }
}

proc Net-stat {} {
    global Net_linkstatus Net_check_interval Net_getstatuscommand

    # Check status of Net link
    set Net_oldstatus $Net_linkstatus
    set Net_linkstatus [ expr ! [catch {eval exec $Net_getstatuscommand }] ]
    # update if change of link status
    if {$Net_oldstatus != $Net_linkstatus} {
	DEBUG "Net is [expr $Net_linkstatus ? \"up\" : \"down\" ]"
         Net_setstatus
	 Net_stop_wait
    }
}

proc Net_start_wait {} {
    global Net_waitcheck_interval Net_wait_period TKGcounter TKG_async_map

    # accelerate status checking and set Net_stop_wait to run
    DEBUG "Starting Net status-check vigilance"
    set TKG_async_map(Net_update) [list $Net_waitcheck_interval [expr $TKGcounter + 2] Net-stat]
    set TKG_async_map(Net_stopwait) \
	[list 1 [expr $TKGcounter + $Net_wait_period] {
	    DEBUG "Net: vigilance timed out"
	    Net_stop_wait
	    Net_setstatus
	}
	]
}

proc Net_stop_wait {} {
    global Net_check_interval Net_check_offset Net_wait_period TKG_async_map
    global TKGcounter

    DEBUG "Ending Net status-check vigilance"
    #get rid of wait button, resume normal checking, and no more of me
    set TKG_async_map(Net_update) [list $Net_check_interval [expr $Net_check_interval + $TKGcounter] Net-stat]
    catch {unset TKG_async_map(Net_stopwait)}
}

proc Net_on_stuff {} {
    global Net_on netwt_image
    DEBUG "Net: trying net-up"
    Net_make_wait_button
    TKGButton Net -text "trying"
    Net_start_wait
}

proc Net_off_stuff {} {
    global Net_off
    DEBUG "Net: trying net-down"
    Net_make_wait_button
    TKGButton Net -text "closing"
    Net_start_wait
}

proc Net_ping {} { 
    global Net_linkstatus Net_auto_ping Net_ping_command 
    global ipaddr 
    if {$Net_linkstatus && $Net_auto_ping} {
	DEBUG "pinging  $ipaddr"
	eval exec $Net_ping_command
    }
}

proc create-Net-window {} {
    global netwt_image TKG_stackprefix Net_window Net_nolabel
    global netup_image netdn_image
    global Net_upforeground Net_upbackground Net_upactiveforeground Net_upactivebackground
    global Net_dnforeground Net_dnbackground Net_dnactiveforeground Net_dnactivebackground
    global Net_wtforeground Net_wtbackground Net_wtactiveforeground Net_wtactivebackground

    uplevel {
	setifunset Net_upforeground chartreuse1
	setifunset Net_upactiveforeground $Net_upforeground
	setifunset Net_upbackground $TKGbuttonbackground
	setifunset Net_upactivebackground $TKGactivebackground
	setifunset Net_dnforeground $TKGbuttonforeground
	setifunset Net_dnactiveforeground $Net_dnforeground
	setifunset Net_dnbackground $TKGbuttonbackground
	setifunset Net_dnactivebackground $TKGactivebackground
	setifunset Net_wtforeground yellow
	setifunset Net_wtactiveforeground $Net_wtforeground
	setifunset Net_wtbackground $TKGbuttonbackground
	setifunset Net_wtactivebackground $TKGactivebackground
    }
    SetImage netup_image $netup_image
    SetImage netdn_image $netdn_image
    SetImage netwt_image $netwt_image

    if { $Net_nolabel } {
	set t ""
    } else {
	set t "wait"
    }   
    TKGButton Net \
	-image netwt_image \
	-text $t \
	-mode netwt \
        -foreground(netup) $Net_upforeground \
        -background(netup) $Net_upbackground \
        -activeforeground(netup) $Net_upactiveforeground \
        -activebackground(netup) $Net_upactivebackground \
        -foreground(netdn) $Net_dnforeground \
        -background(netdn) $Net_dnbackground \
        -activeforeground(netdn) $Net_dnactiveforeground \
        -activebackground(netdn) $Net_dnactivebackground \
        -foreground(netwt) $Net_wtforeground \
        -background(netwt) $Net_wtbackground \
        -activeforeground(netwt) $Net_wtactiveforeground \
        -activebackground(netwt) $Net_wtactivebackground 

  TKGPopupAddClient Net
  .tkgpopup.net add checkbutton\
      -label "Ping periodically to keep connection up " -variable Net_auto_ping
  .tkgpopup.net add command\
	-label "Show IP address " -command {
	  TKGDialog ipinfo -wmtitle "IP Information"\
	      -message "IP Address is $ipaddr"
	}
  .tkgpopup.net add command\
      -label "Remove Net Button " -command {
	catch {unset TKG_async_map(Net_update)}
	destroy $Net_window
	set index [.tkgpopup index "NET:"]
	.tkgpopup delete $index [expr $index +1]
	}
  }

DEBUG "Loaded Net.tcl"
