#include <stdio.h>
#include <stdlib.h>
#include <Xm/PushB.h>
#include <X11/xpm.h>

main(int argc, char *argv[])
{
    XtAppContext app;
    Widget top, button;
    int status;
    Pixmap pixmap, armPixmap;
    XpmAttributes attributes;
    XpmColorSymbol symbols[2];
    Pixel color;

    top = XtAppInitialize(&app, "BulletButton", NULL, 0, &argc, argv,
			  NULL, NULL, 0);
    button = XmCreatePushButton(top, "button", NULL, 0);

    /* create a red bullet pixmap with none set to the button background */
    XtVaGetValues(button, XmNbackground, &color, NULL);

    symbols[0].name = NULL;
    symbols[0].value = "none";
    symbols[0].pixel = color;

    attributes.colorsymbols = symbols;
    attributes.numsymbols = 1;
    attributes.valuemask = XpmColorSymbols;
    status = XpmReadFileToPixmap(XtDisplay(top),
				 XRootWindowOfScreen(XtScreen(top)),
				 "bullet_transp.xpm", &pixmap, NULL,
				 &attributes);
    if (status != XpmSuccess) {
	fprintf(stderr, "XpmError: %s\n", XpmGetErrorString(status));
	exit(1);
    }
    /* then, create a green pixmap with none set to the button armColor */
    XtVaGetValues(button, XmNarmColor, &color, NULL);

    symbols[0].pixel = color;
    symbols[1].name = "Foreground";
    symbols[1].value = "green";
    attributes.numsymbols = 2;
    attributes.valuemask = XpmColorSymbols;

    status = XpmReadFileToPixmap(XtDisplay(top),
				 XRootWindowOfScreen(XtScreen(top)),
				 "bullet_transp.xpm", &armPixmap, NULL,
				 &attributes);
    if (status != XpmSuccess) {
	fprintf(stderr, "XpmError: %s\n", XpmGetErrorString(status));
	exit(1);
    }
    /* now put the two pixmaps onto the button */
    XtVaSetValues(button, XmNlabelType, XmPIXMAP,
		  XmNlabelPixmap, pixmap,
		  XmNarmPixmap, armPixmap,
		  NULL);

    XtManageChild(button);
    XtRealizeWidget(top);
    XtAppMainLoop(app);
}
