#include <stdio.h>
#include <stdlib.h>
#include <Xm/PushB.h>
#include <X11/xpm.h>

main(int argc, char *argv[])
{
    XtAppContext app;
    Widget top, button;
    int status;
    Pixmap pixmap;
    XpmAttributes attributes;

    /* create a simple hierarchy with a PushButton widget */
    top = XtAppInitialize(&app, argv[0], NULL, 0, &argc,
			       argv, NULL, NULL, 0);
    button = XmCreatePushButton(top, "button", NULL, 0);

    /* initialize the XpmAttributes valuemask */
    attributes.valuemask = 0;

    /* create a pixmap from the XPM file */
    status = XpmReadFileToPixmap(XtDisplay(top),
				 XRootWindowOfScreen(XtScreen(top)),
				 "bullet.xpm", &pixmap, NULL, &attributes);
    if (status != XpmSuccess) {
	fprintf(stderr, "XpmError: %s\n", XpmGetErrorString(status));
	exit(1);
    }
    /* resize the button to the pixmap size plus some margins,
       and put the pixmap onto the button  */
    XtVaSetValues(button,
		  XmNwidth, attributes.width + 50,
		  XmNheight, attributes.height + 25,
		  XmNlabelType, XmPIXMAP,
		  XmNlabelPixmap, pixmap,
		  NULL);
    XtManageChild(button);
    XtRealizeWidget(top);
    XtAppMainLoop(app);
}
