/* Copyright 1993 GROUPE BULL -- See license conditions in file COPYRIGHT */
/*
 * main.h
 *
 *	Prototypes for the Tcl Tooltalk interface
 *
 * $Id: main.h,v 1.5 93/08/26 16:24:50 beust Exp Locker: beust $
 */

#include <tcl.h>
#include <tk.h>
#include <tt_c.h>
#include <stdio.h>
#define D(x) x

#define TOOCL_MAJOR_VERSION 1
#define TOOCL_MINOR_VERSION 6
#define TOOCL_VERSION "1.6"

/* A simple macro to check the number of arguments */
#define ARG(n) if (argc != n+1) { fprintf(stderr, "%s: expecting %d arguments\n", argv[0], n); return -1; }

/* Our main interpretor (shouldn't be global). */
extern Tcl_Interp *Interp;    /* tclttAppInit.c */

/* To store results */
extern char Tcltt_Result[256];  /* tclttAppInit.c */

/* Just to make the code shorter... */
#define TCL_COMMAND_PROTO(f) int f(ClientData data, Tcl_Interp *interp,\
				   int argc, char **argv)

/*
 * tclttAppInit.c
 */

int
Tcltt_AppInit(Tcl_Interp *interp);

/*
 * tclttMisc.c
 */

Tt_callback_action
TclTT_generic_pattern_callback(Tt_message m, Tt_pattern p);

TCL_COMMAND_PROTO(TclTT_wait_for_message);
TCL_COMMAND_PROTO(TclTT_main_tooltalk_callback);

TCL_COMMAND_PROTO(Tcltt_close);
TCL_COMMAND_PROTO(Tcltt_open);
TCL_COMMAND_PROTO(Tcltt_X_session);
TCL_COMMAND_PROTO(Tcltt_status_message);
TCL_COMMAND_PROTO(Tcltt_fd);
TCL_COMMAND_PROTO(Tcltt_prequest_create);
TCL_COMMAND_PROTO(Tcltt_pnotice_create);
TCL_COMMAND_PROTO(Tcltt_mark);
TCL_COMMAND_PROTO(Tcltt_release);
TCL_COMMAND_PROTO(Tcltt_pointer_error);
TCL_COMMAND_PROTO(Tcltt_int_error);
TCL_COMMAND_PROTO(Tcltt_error_pointer);
TCL_COMMAND_PROTO(Tcltt_error_int);
TCL_COMMAND_PROTO(Tcltt_onotice_create);
TCL_COMMAND_PROTO(Tcltt_orequest_create);
TCL_COMMAND_PROTO(Tcltt_objid_equal);
TCL_COMMAND_PROTO(Tcltt_objid_objkey);
TCL_COMMAND_PROTO(Tcltt_ptype_declare);

/*
 * tclttSession.c
 */

TCL_COMMAND_PROTO(Tcltt_session_join);
TCL_COMMAND_PROTO(Tcltt_session_quit);
TCL_COMMAND_PROTO(Tcltt_session_propname);
TCL_COMMAND_PROTO(Tcltt_session_propnames_count);
TCL_COMMAND_PROTO(Tcltt_session_prop);
TCL_COMMAND_PROTO(Tcltt_session_prop_add);
TCL_COMMAND_PROTO(Tcltt_session_prop_count);
TCL_COMMAND_PROTO(Tcltt_session_prop_set);
TCL_COMMAND_PROTO(Tcltt_initial_session);

/*
 * tclttDefault.c
 */

TCL_COMMAND_PROTO(Tcltt_default_session);
TCL_COMMAND_PROTO(Tcltt_default_ptype);
TCL_COMMAND_PROTO(Tcltt_default_ptype_set);
TCL_COMMAND_PROTO(Tcltt_default_file);
TCL_COMMAND_PROTO(Tcltt_default_file_set);
TCL_COMMAND_PROTO(Tcltt_default_session_set);
TCL_COMMAND_PROTO(Tcltt_default_procid);
TCL_COMMAND_PROTO(Tcltt_default_procid_set);

/*
 * tclttMessage.c
 */

TCL_COMMAND_PROTO(Tcltt_message_create);
TCL_COMMAND_PROTO(Tcltt_message_class_set);
TCL_COMMAND_PROTO(Tcltt_message_address_set);
TCL_COMMAND_PROTO(Tcltt_message_send);
TCL_COMMAND_PROTO(Tcltt_message_scope_set);
TCL_COMMAND_PROTO(Tcltt_message_op);
TCL_COMMAND_PROTO(Tcltt_message_op_set);
TCL_COMMAND_PROTO(Tcltt_message_arg_val);
TCL_COMMAND_PROTO(Tcltt_message_arg_add);
TCL_COMMAND_PROTO(Tcltt_message_arg_val_set);
TCL_COMMAND_PROTO(Tcltt_message_callback_add);
TCL_COMMAND_PROTO(Tcltt_message_send);
TCL_COMMAND_PROTO(Tcltt_message_reply);
TCL_COMMAND_PROTO(Tcltt_message_receive);
TCL_COMMAND_PROTO(Tcltt_message_create_super);
TCL_COMMAND_PROTO(Tcltt_message_destroy);
TCL_COMMAND_PROTO(Tcltt_message_reject);
TCL_COMMAND_PROTO(Tcltt_message_fail);
TCL_COMMAND_PROTO(Tcltt_message_pattern);
TCL_COMMAND_PROTO(Tcltt_message_user);
TCL_COMMAND_PROTO(Tcltt_message_user_set);
TCL_COMMAND_PROTO(Tcltt_message_arg_mode);
TCL_COMMAND_PROTO(Tcltt_message_arg_type);
TCL_COMMAND_PROTO(Tcltt_message_arg_val);
TCL_COMMAND_PROTO(Tcltt_message_arg_bval);
TCL_COMMAND_PROTO(Tcltt_message_arg_bval_set);
TCL_COMMAND_PROTO(Tcltt_message_barg_add);
TCL_COMMAND_PROTO(Tcltt_message_arg_ival);
TCL_COMMAND_PROTO(Tcltt_message_arg_ival_set);
TCL_COMMAND_PROTO(Tcltt_message_iarg_add);
TCL_COMMAND_PROTO(Tcltt_message_args_count);
TCL_COMMAND_PROTO(Tcltt_message_class);
TCL_COMMAND_PROTO(Tcltt_message_file);
TCL_COMMAND_PROTO(Tcltt_message_file_set);
TCL_COMMAND_PROTO(Tcltt_message_object);
TCL_COMMAND_PROTO(Tcltt_message_object_set);
TCL_COMMAND_PROTO(Tcltt_message_opnum);
TCL_COMMAND_PROTO(Tcltt_message_otype);
TCL_COMMAND_PROTO(Tcltt_message_otype_set);
TCL_COMMAND_PROTO(Tcltt_message_address);
TCL_COMMAND_PROTO(Tcltt_message_handler);
TCL_COMMAND_PROTO(Tcltt_message_handler_set);
TCL_COMMAND_PROTO(Tcltt_message_handler_ptype);
TCL_COMMAND_PROTO(Tcltt_message_handler_ptype_set);
TCL_COMMAND_PROTO(Tcltt_message_disposition);
TCL_COMMAND_PROTO(Tcltt_message_disposition_set);
TCL_COMMAND_PROTO(Tcltt_message_scope);
TCL_COMMAND_PROTO(Tcltt_message_sender);
TCL_COMMAND_PROTO(Tcltt_message_sender_ptype);
TCL_COMMAND_PROTO(Tcltt_message_sender_ptype_set);
TCL_COMMAND_PROTO(Tcltt_message_session);
TCL_COMMAND_PROTO(Tcltt_message_session_set);
TCL_COMMAND_PROTO(Tcltt_message_state);
TCL_COMMAND_PROTO(Tcltt_message_status);
TCL_COMMAND_PROTO(Tcltt_message_status_set);
TCL_COMMAND_PROTO(Tcltt_message_status_string);
TCL_COMMAND_PROTO(Tcltt_message_status_string_set);
TCL_COMMAND_PROTO(Tcltt_message_uid);
TCL_COMMAND_PROTO(Tcltt_message_gid);

/*
 * tclttPattern.c
 */

TCL_COMMAND_PROTO(Tcltt_pattern_create);
TCL_COMMAND_PROTO(Tcltt_pattern_register);
TCL_COMMAND_PROTO(Tcltt_pattern_address_add);
TCL_COMMAND_PROTO(Tcltt_pattern_class_add);
TCL_COMMAND_PROTO(Tcltt_pattern_scope_add);
TCL_COMMAND_PROTO(Tcltt_pattern_op_add);
TCL_COMMAND_PROTO(Tcltt_pattern_category_set);
TCL_COMMAND_PROTO(Tcltt_pattern_callback_add);
TCL_COMMAND_PROTO(Tcltt_pattern_destroy);
TCL_COMMAND_PROTO(Tcltt_pattern_unregister);
TCL_COMMAND_PROTO(Tcltt_pattern_user);
TCL_COMMAND_PROTO(Tcltt_pattern_user_set);
TCL_COMMAND_PROTO(Tcltt_pattern_category_set);
TCL_COMMAND_PROTO(Tcltt_pattern_arg_add);
TCL_COMMAND_PROTO(Tcltt_pattern_class_add);
TCL_COMMAND_PROTO(Tcltt_pattern_file_add);
TCL_COMMAND_PROTO(Tcltt_pattern_object_add);
TCL_COMMAND_PROTO(Tcltt_pattern_opnum_add);
TCL_COMMAND_PROTO(Tcltt_pattern_otype_add);
TCL_COMMAND_PROTO(Tcltt_pattern_disposition_add);
TCL_COMMAND_PROTO(Tcltt_pattern_sender_add);
TCL_COMMAND_PROTO(Tcltt_pattern_sender_ptype_add);
TCL_COMMAND_PROTO(Tcltt_pattern_session_add);
TCL_COMMAND_PROTO(Tcltt_pattern_state_add);

/*
 * tclttFile.c
 */

TCL_COMMAND_PROTO(Tcltt_file_join);
TCL_COMMAND_PROTO(Tcltt_file_quit);
TCL_COMMAND_PROTO(Tcltt_file_move);
TCL_COMMAND_PROTO(Tcltt_file_copy);
TCL_COMMAND_PROTO(Tcltt_file_destroy);

/*
 * tclttOtype.c
 */

TCL_COMMAND_PROTO(Tcltt_otype_deriveds_count);
TCL_COMMAND_PROTO(Tcltt_otype_derived);
TCL_COMMAND_PROTO(Tcltt_otype_base);
TCL_COMMAND_PROTO(Tcltt_otype_is_derived);
TCL_COMMAND_PROTO(Tcltt_otype_osig_count);
TCL_COMMAND_PROTO(Tcltt_otype_hsig_count);
TCL_COMMAND_PROTO(Tcltt_otype_osig_op);
TCL_COMMAND_PROTO(Tcltt_otype_hsig_op);
TCL_COMMAND_PROTO(Tcltt_otype_osig_args_count);
TCL_COMMAND_PROTO(Tcltt_otype_hsig_args_count);
TCL_COMMAND_PROTO(Tcltt_otype_osig_arg_mode);
TCL_COMMAND_PROTO(Tcltt_otype_hsig_arg_mode);
TCL_COMMAND_PROTO(Tcltt_otype_osig_arg_type);
TCL_COMMAND_PROTO(Tcltt_otype_hsig_arg_type);

/*
 * tclSpec.c
 */

TCL_COMMAND_PROTO(Tcltt_spec_create);
TCL_COMMAND_PROTO(Tcltt_spec_write);
TCL_COMMAND_PROTO(Tcltt_spec_destroy);
TCL_COMMAND_PROTO(Tcltt_spec_file);
TCL_COMMAND_PROTO(Tcltt_spec_type);
TCL_COMMAND_PROTO(Tcltt_spec_type_set);
TCL_COMMAND_PROTO(Tcltt_spec_move);
TCL_COMMAND_PROTO(Tcltt_spec_propname);
TCL_COMMAND_PROTO(Tcltt_spec_propnames_count);
TCL_COMMAND_PROTO(Tcltt_spec_prop);
TCL_COMMAND_PROTO(Tcltt_spec_prop_add);
TCL_COMMAND_PROTO(Tcltt_spec_prop_count);
TCL_COMMAND_PROTO(Tcltt_spec_prop_set);
