/*
 *
 * $Id: bus.c,v 1.8 1994/08/02 15:46:53 beust Exp $
 */

#include "main.h"


/***************************************************************************
 * Callbacks
 ***************************************************************************/

/* callback of type Kt_ServerMsgCallback */
void
cbObserve(Kt_Context context, void *userData, Kt_Message msg, CARD32 id)
{
   GV gv = (GV) userData;
   int i, n = kt_MessageArgCount(msg);
   char *str, str2[128];

   sprintf(str2, "<<< Observed a message from '%s' (%d arguments)\n",
	   kt_MessageSender(msg), n);
   guiLog1(gv, str2);
   guiLog2d(gv, "<<< Matching id %d", id);
   guiLog2(gv, "        Operation : ", kt_MessageOperationGet(msg));
   for (i=0; i < n; i++) {
      kt_MessageStringGet(msg, i, & str);
      guiLog2(gv, "      ", str);
      free(str);
   }
}

/* callback of type Kt_ReplyMsgCallback */
/*
** Called when I receive a reply to a request
*/
void
cbReply(Kt_Context context, void *userData, Kt_Message msg, CARD32 spec)
{
   GV gv = (GV) userData;
   char *arg;
   int i, n = kt_MessageArgCount(msg);
   char str2[128];

   sprintf(str2, "<<< Received a reply to request %d from '%s'", spec,
	   kt_MessageSender(msg));
   guiLog1(gv, str2);
   guiLog2(gv, "        ", kt_MessageOperationGet(msg));
   for (i=0; i<n; i++) {
      kt_MessageStringGet(msg, i, & arg);
      guiLog2(gv, "        arg : ", arg);
      free(arg);
   }
}

/* callback of type Kt_HandlerMsgCallback */
/*
** Called each time a request is sent to a Koalatalk Resource Location
** matching one of our Koalatalk Resource Spec
*/
void
cbHandle(Kt_Context context, void *userData, Kt_Message msg, CARD32 spec)
{
   GV gv = (GV) userData;
   char *a1 = "<no args>", *a2, *a3, str[128];
   int i, n = kt_MessageArgCount(msg) - 1;

   a3 = a2 = a1;
   if (NULL != gv -> lastRequest)
      kt_MessageFree(gv -> lastRequest);
   gv -> lastRequest = kt_MessageCopy(msg);
   sprintf(str, "<<< Handled a message from peer '%s'",
	   kt_MessageSender(msg));
   guiLog1(gv, str);
   guiLog2(gv, "        ", kt_MessageOperationGet(msg));
   if (n > 2) n = 2;
   kt_MessageStringGet(msg, n--, & a3);
   kt_MessageStringGet(msg, n--, & a2);
   kt_MessageStringGet(msg, n, & a1);
   guiGetReply(gv, a1, a2, a3, (CARD32) spec);
   free(a1); free(a2); free(a3);
}

/* callback of type Kt_PeerMsgCallback */
void
cbDirect(Kt_Context context, void *userData, Kt_Message msg)
{
   GV gv = (GV) userData;
   char *arg1, str[128];

   sprintf(str, "<<< Received direct message from peer '%s'\n",
	   kt_MessageSender(msg));
   if (kt_MessageArgCount(msg) > 0)
      kt_MessageStringGet(msg, 0, & arg1);
   guiLog1(gv, str);
   guiLog2(gv, "        ", kt_MessageOperationGet(msg));
   guiLog2(gv, "        arg1 : ", arg1);
   free(arg1);
}

/***************************************************************************
 * Interface to the bus
 ***************************************************************************/

#if 0
static void
busPrintFd(fd_set *fds)
{
   int i;
   printf("----- list of fds:\n");
   for (i=0; i<getdtablesize(); i++)
      if (FD_ISSET(i, fds)) { printf("%d ", i); fflush(stdout); }
   printf("\n-----\n");
}
#endif

#ifdef USE_SELECT
#else
void
ktHandleInput(XtPointer userData, int *fd, XtInputId *xid)
{
   GV gv = (GV) userData;
   fd_set fds;
   FD_ZERO(& fds);
   FD_SET(*fd, & fds);
   kt_HandleInput(gv -> ktContext, fds);
}

#endif /* USE_SELECT */
void
busAddInput(int fd, void *userData)
{
   GV gv = (GV) userData;
#ifdef USE_SELECT
   FD_SET(fd, & gv -> fds);
#else
   InfoFd_t fdi;
   NEW(fdi, InfoFdRec_t);
   fdi -> id = XtAppAddInput(gv -> appContext, fd, (XtPointer) XtInputReadMask,
			     ktHandleInput, gv);
   gv -> fdi[fd] = fdi;
#endif
   printf("addinput adding %d\n", fd);

}

void
busRemoveInput(int fd, void *userData)
{
   GV gv = (GV) userData;
#ifdef USE_SELECT
   FD_CLR(fd, & gv -> fds);
#else
   InfoFd_t fdi = gv -> fdi[fd];
   XtRemoveInput(fdi -> id);
   free(fdi);
#endif

}

void
busInit(GV gv)
{
   Kt_Context context;

   /*
   ** Zero the main fd_set
   */
#ifdef USE_SELECT
   FD_ZERO(& gv -> fds);
#endif /* USE_SELECT */

   /*
   ** Initialize Koalatalk
   */
   context = kt_Init(busAddInput, gv, busRemoveInput, gv);
   gv -> ktContext = context;

   /*
   ** Declare a callback to be used for any direct connection to me
   */
   kt_PeerAddMsgCallback(context, cbDirect, gv);


}

Bool
busServerConnect(GV gv, char *serverIceCoord)
{
   Bool result = False;
   if (KT_OK ==
       kt_OpenServerConnection(gv -> ktContext, serverIceCoord,
			       "Koalatalk Monitor")) {
      guiLog2(gv, "Connected to server ", serverIceCoord);
      result = True;
   }
   else {
      guiLog2(gv, "Couldn't connect to server ", serverIceCoord);
      result = False;
   }

   return result;
}

void
busMessageSend(GV gv, char *strOperation,
	       char *strDest, char *s1, char *s2, char *s3,
	       Bool isNotice, Bool isKrl)
{
   Kt_Message msg;
   Kt_KRL krl;
   Kt_Status status;
   int i;
   char *arg[3];
   arg[0] = s1;
   arg[1] = s2;
   arg[2] = s3;

   /*
   ** Creating message 
   */
   msg = kt_MessageNew();
   kt_MessageOperationSet(msg, strOperation);
   for (i = 0; i < 3; i++) {
      if (0 != strlen(arg[i]))
	 kt_MessageStringAdd(msg, arg[i]);
   }
   if (0 == strlen(strDest)) strDest = "testKRL";

   /*
   ** Sending to a KRL?
   */
   if (True == isKrl) {
      krl = kt_KRLNew(gv -> ktContext, strDest);
      if (0 != krl) {
	 if (True == isNotice) {
	    /*
	    ** Sending a notice
	    */
	    guiLog2(gv, ">>> Sent a notice to KRL:", strDest);
	    status = kt_MessageSend(gv -> ktContext, krl, msg);
	    if (KT_OK != status)
	       guiLog2(gv, "    *** couldn't send notice", "");
	 }
	 else {
	    /*
	    ** Sending a request
	    */
	    guiLog2(gv,  ">>> Sent a request to KRL:", strDest);
	    gv -> lastRequestId =
	       kt_MessageSendWithReply(gv -> ktContext, krl, msg,
				       KT_START,
				       cbReply, gv);
	    if (-1 == status)
	       guiLog2(gv, "    *** couldn't send request", "");
	 }
	 kt_KRLFree(krl);
      }
      else {
	 guiLog2(gv, "*** couldn't declare KRL, did you connect to a server?", "");
      }
   }
   /*
   ** No, sending to a peer then
   */
   else {
      guiLog2(gv, ">>> Sent message to peer", "");
      status = kt_MessageSendToPeer(gv -> ktContext, strDest, msg);
      if (KT_OK != status)
	 guiLog2(gv, "    *** couldn't send message", "");
   }
   kt_MessageFree(msg);
}

int
busKRSAdd(GV gv, char *krSpec, Bool observe, CARD32 *returnedKRS)
{
   int result;
   CARD32 krs;

   if (NULL != krSpec) {
      if (0 != strlen(krSpec)) {
	 if (True == observe) {
	    krs = kt_KRObserve(gv -> ktContext, krSpec, cbObserve, gv);
	 }
	 else {
	    krs = kt_KRHandle(gv -> ktContext, krSpec, cbHandle, gv);
	 }
      }
      if (0 == krs) {
	 guiLog2(gv, "Can't observe, connect to a server first", "");
	 result = 0;
      }
      else {
	 *returnedKRS = krs;
	 result = 1;
      }
   }

   return result;
}

void
busUpdate(GV gv)
{
   int xfd;
   Kt_Context context = gv -> ktContext;

#ifdef USE_SELECT
   /*
   ** Monitor the X file descriptor
   */
   gv -> xfd = XConnectionNumber(XtDisplay(gv -> pb2));
   busAddInput(gv -> xfd, gv);
#endif /* USE_SELECT */

   /*
   ** Create a message to be sent when I die
   */
   {
      Kt_Message msg;
      Kt_KRL krl;
      krl = kt_KRLNew(context, "mon");
      msg = kt_MessageNew();
      kt_MessageOperationSet(msg, "quit");
      kt_MessageStringAdd(msg, "ktmon is dying");
      kt_MessageSendOnExit(context, krl, msg);

      kt_MessageFree(msg);
      kt_KRLFree(krl);
   }

}

char *
busReturnIdentity(GV gv)
{
   return kt_ReturnIdentity(gv -> ktContext);
}

void
busReply(GV gv, char *a1, char *a2, char *a3)
{
   Kt_Message reply;

   reply = kt_MessageNew();
   kt_MessageStringAdd(reply, a1);
   kt_MessageStringAdd(reply, a2);
   kt_MessageStringAdd(reply, a3);
   kt_MessageReply(gv -> ktContext, gv -> lastRequest, reply);
   kt_MessageFree(reply);
}

int
busKRSRemove(GV gv, CARD32 krs)
{
   int result = 1;

   fprintf(stderr, "*** removing KRS not implemented\n");
/*
   if (KT_ERR == kt_KRUnObserve(gv -> ktContext, krs))
      result = 0;
*/
}

char *
busLocateServer()
{
   char *result;
   char **servers;
   int n, i;
   kt_LocateServer(& servers, & n);
   if (n > 0)
      result = (char *) kt_strdup(servers[0]);
   else {
      result = "<no server found>";
   }

   for (i=0; i < n; i++) free(servers[i]);
   free(servers);

   return result;
}

void
busMainLoop(GV gv)
{

#ifdef USE_SELECT
   while (1) {
      int ready;
      fd_set fds;

      setjmp(KoalaTalk_MainLoopJmp);
      fds = gv -> fds;
      ready = select(kt_getdtablesize(), & fds, 0, 0, 0);
      if (ready > 0) {
	 if (FD_ISSET(gv -> xfd, & fds))   /* an X event */
	    guiHandleXInput(gv);
	 else
	    kt_HandleInput(gv -> ktContext, fds);   /* a Koalatalk event */
      }
   }
#else
   XtAppMainLoop(gv -> appContext);
#endif /* USE_SELECT */
}
