/* Copyright (C) 1994 Groupe BULL. See file COPYRIGHT for details */
/*
 *
 * $Id: kt_mainloop.c,v 1.3 1994/12/15 13:38:12 beust Exp $
 */

#include <assert.h>
#include <sys/types.h>
#include <sys/times.h>
#ifdef DPX20
#include <sys/select.h>
#endif
#include "kt_lib.h"
#include "kt_typesP.h"
#include "kt_protocolP.h"
#include "database.h"

#if 0
jmp_buf KoalaTalk_MainLoopJmp; /* really ugly, must take that off */
#endif

void
kt_addInput(int fd, void *userData)
{
   Kt_Context context = (Kt_Context) userData;
   DP(printf("adding fd %d\n", fd));
   FD_SET(fd, & context -> mainFdSet);
}

void
kt_removeInput(int fd, void *userData)
{
   Kt_Context context = (Kt_Context) userData;
   DP(printf("removing an input\n"));
   FD_CLR(fd, & context -> mainFdSet);
}

void
kt_mainLoop(Kt_Context context)
{
   fd_set fds;
   int ready;

   while (1) {
      fds = context -> mainFdSet;
      ready = select(kt_getdtablesize(), & fds, 0, 0, 0);
      if (ready > 0)
	 kt_HandleInput(context, fds);
   }
}

void
kt_mainLoopOld(Kt_Context context)
{
   Kt_CallbackAddInput addInput = context -> addInput;
   Kt_CallbackAddInput removeInput = context -> removeInput;
   DataBase db;
   Kt_serverConnection sconn; 
   Kt_PeerConnection pconn;
   IceProcessMessagesStatus aStatus;
   fd_set fds;
   int ready;

/*
   setjmp(KoalaTalk_MainLoopJmp);
*/

   /*
   ** Watch all the incoming connections
   */


#if 0
   /*
   ** Plus any user-defined file descriptor
   */
   db = context -> userFileDescriptors;
   ASSERT(db);
   DB_Rewind(db);
   while (! DB_EndOfDataBase(db)) {
      Kt_userFileDescriptor ufd = DB_NextEntry(db);
      FD_SET(ufd -> fd, & fds);
#if 0
      if (0 != ufd -> flushFunction) {  /* any flush function? */
	 void (*f)() = ufd -> flushFunction;
	 (*f)(ufd -> flushFunctionUserData);
      }
#endif
   }
#endif

   /*
   ** At this point, context -> mainFdSet has been all set up
   ** either by our default kt_addInput, or by the one supplied
   ** by the caller (see kt_Init()).
   ** Now wait...
   */
   fds = context -> mainFdSet;
   sconn = context -> serverConn;
   ready = select(kt_getdtablesize(), & fds, NULL, NULL, NULL);
   if (ready < 0) {
      perror("kt_mainloop.c: select()");
      exit(-1);
   }

   while (ready > 0) {
      IceConn newConn = context -> directNewConn;

#if 0      
      /*
      ** Something just arrived.
      ** ... from one of the user-defined file descriptors?
      */
      db = context -> userFileDescriptors;
      DB_Rewind(db);
      while (! DB_EndOfDataBase(db)) {
	 Kt_userFileDescriptor ufd = DB_NextEntry(db);
	 if (FD_ISSET(ufd -> fd, & fds)) {
	    /*
	    ** ... then call the supplied callback
	    */
	    void (*f)() = ufd -> f;
	    (*f)(ufd -> userData);
	    ready--;
	 }
     
#endif }

      /*
      ** ... from the server?
      */
      if (NULL != sconn)
	 if (FD_ISSET(IceConnectionNumber(sconn -> iceConn), & fds)) {
	    ready--;
	    aStatus = IceProcessMessages(sconn -> iceConn, NULL, NULL);
	 }

      /*
      ** ... a direct connection request?
      */
      db = context -> directIdentities;
      DB_Rewind(db);
      while (! DB_EndOfDataBase(db)) {
	 Kt_directIdentity di = DB_NextEntry(db);
	 if (FD_ISSET(di -> directFd, & fds)) {
	    IceAcceptStatus status;
	    ready--;
	    newConn = context -> directNewConn =
	       IceAcceptConnection(di -> directListenObj, & status);
	    /*
            ** Add it to the list of fd's we are watching
            */
	    DP(printf("mainloop, direct conn. req: %d\n", IceConnectionNumber(newConn), context));
	    (*addInput)(IceConnectionNumber(newConn),
			context -> addInputUserData);

	    ASSERT(newConn);
	    IceProcessMessages(newConn, NULL, NULL);
	 }
      }

      /*
      ** ...or data on the dangling connection
      */
      if (NULL != newConn &&
          FD_ISSET(IceConnectionNumber(context -> directNewConn), & fds)) {
         ready--;
         IceProcessMessages(newConn, NULL, NULL);
         if (IceConnectAccepted == IceConnectionStatus(newConn)) {
            Kt_PeerConnection dc;
	    NEW(dc, Kt_PeerConnectionRec);
            memset(dc, 0, sizeof(dc));
            dc -> iceConn = newConn;
            DB_AddEntry(context -> directConn, dc);
            newConn = context -> directNewConn = NULL;
	    (*removeInput)(IceConnectionNumber(newConn),
			   context -> removeInputUserData);
         }
      }
      /*
      ** ... or an actual direct connection
      */
      db = context -> directConn;
      DB_Rewind(db);
      while (! DB_EndOfDataBase(db)) {
         Kt_PeerConnection dc;
         dc = (Kt_PeerConnection) DB_NextEntry(db);
         if (FD_ISSET(IceConnectionNumber(dc -> iceConn), & fds)) {
            ready--;
            IceProcessMessages(dc -> iceConn, NULL, NULL);
         }
      }
      /*
      ** On a custom connection maybe?
      */
      NULL;
   }
}


