//
// Copyright (C) 1994-1995 Harry Danilevsky and Andrew Renalds
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish and distribute copies of the 
// Software, and to permit persons to whom the Software is furnished to do so,
// subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESSED OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// HARRY DANILEVSKY AND ANDREW RENALDS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

#include <stream.h>
#include <Xm/Xm.h>
#include <Xm/BulletinB.h>
#include <Xm/DrawnB.h>
#include <Xm/PushB.h>
#include <DD++/DDstring.H>
#include <DD++/SpecificDragSite.H>


class StringDropTarget: public DropTarget
{
  int receive (Widget) {
    cout << "String received: " << * ((DraggableString*)dPtr) << endl;
    return 1;
  }
public:
  StringDropTarget(DraggableString& s): DropTarget(s) {}
};


main( int argc, char *argv[] )
{
  XtAppContext app_context;
  Widget toplevel, bb, button1;
  Arg args[15];
  int n;
  Pixmap drop_pixmap = (Pixmap)NULL;
  Pixel fg, bg;

  toplevel = XtAppInitialize( &app_context, "DragDropTest", NULL, 0,
                              &argc, argv, NULL, NULL, 0 );

  n = 0;
  XtSetArg( args[n], XmNwidth, 85 );  n++;
  XtSetArg( args[n], XmNheight, 85 );  n++;
  bb = XtCreateManagedWidget( "", xmBulletinBoardWidgetClass,
                              toplevel, args, n );

  XtVaGetValues( bb, XmNforeground, &fg, XmNbackground, &bg, NULL );
  drop_pixmap = XmGetPixmap( XtScreen( bb ), "c++.xbm", fg, bg );

  n = 0;
  XtSetArg( args[n], XmNwidth, 70 );  n++;
  XtSetArg( args[n], XmNheight, 70 );  n++;
  XtSetArg( args[n], XmNx, 5 );  n++;
  XtSetArg( args[n], XmNy, 5 );  n++;
  XtSetArg( args[n], XmNshadowType, XmSHADOW_OUT );  n++;
  XtSetArg( args[n], XmNlabelType, XmPIXMAP );  n++;
  if( drop_pixmap != XmUNSPECIFIED_PIXMAP )  
  {
    XtSetArg( args[n], XmNlabelPixmap, drop_pixmap );  n++;
  }
  button1 = XtCreateManagedWidget( "", xmDrawnButtonWidgetClass,
                                       bb, args, n );

  DraggableString dstring("Hello");
  SpecificDragSite dragSite1(button1, XmBLEND_JUST_SOURCE, "c++.xbm");
  dragSite1.objectToDrag(dstring);

  DropSite dropSite1(button1, XmDROP_COPY|XmDROP_MOVE, XmDRAG_UNDER_SHADOW_IN );

  DraggableString ddstring;
  StringDropTarget dropTarget1(ddstring);
  dropSite1.append(&dropTarget1);

  XtRealizeWidget( toplevel );
  XtAppMainLoop( app_context );
}
