#ifndef _DDSTRING_H_
#define _DDSTRING_H_

//
// Copyright (C) 1994-1995 Harry Danilevsky and Andrew Renalds
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish and distribute copies of the 
// Software, and to permit persons to whom the Software is furnished to do so,
// subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESSED OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// HARRY DANILEVSKY AND ANDREW RENALDS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

#include <DD++/DD.H>

class DraggableString: public Draggable 
{
private:
  
  virtual const char * atomName() const { return "STRING"; }
  virtual void saveOn (o_stream &o) {
    if(s)  o << s;
  }
  virtual void restoreFrom(i_stream &i, int dataSize)
  {
    if( i.good() )
      {
	if( dataSize > 0 ) {
	  delete s;
	  s = new char[dataSize+1];
	  // XDR objects carry object size along with the object, so DDistream::operator >>
	  // will extract the string properly. In case of istream::operator >> if the
	  // string contains white spaces, then it will be only partially extracted;
	  // that's why istream::get() is used.
#ifdef DD_USE_XDR
	  i >> s;
#else      
      // terminating 0 will be appended automatically
	  i.get(s, dataSize+1, 0);
#endif      
	}
      }
  }
  
public:
  char *s;
  
  DraggableString(): s(0) {}
  DraggableString( char *str ) : s(0) {
    if( str ) {
      s = new char[ strlen(str)+1 ];
      strcpy( s, str );
    }
  }
  virtual ~DraggableString() { delete s; }
  DraggableString& operator = ( const DraggableString& tmp ) {
    if (tmp.s)
      {
	delete s;
	s = new char[ strlen(tmp.s)+1 ];
	strcpy( s, tmp.s );
      }
    return *this;
  }
friend ostream& operator << (ostream& o, const DraggableString& d) {
  o << d.s;
  return o;
}

};

#endif
