#ifndef _DDDOUBLE_H_
#define _DDDOUBLE_H_

//
// Copyright (C) 1994-1995 Harry Danilevsky and Andrew Renalds
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish and distribute copies of the 
// Software, and to permit persons to whom the Software is furnished to do so,
// subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESSED OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// HARRY DANILEVSKY AND ANDREW RENALDS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

#include <DD++/DD.H>
#include <iomanip.h>

class DraggableDouble: public Draggable 
{
  private:

  virtual const char * atomName() const {
    return "DOUBLE";
  }
  virtual void saveOn (o_stream &o) {
    o << dbl;
  }
  virtual void restoreFrom(i_stream &i, int) {
    if (i.good())
      i >> dbl;
  }
  
public:
  
  double dbl;
  DraggableDouble(): dbl(0) {}
  DraggableDouble(double j): dbl(j) {}
  friend ostream& operator << (ostream& o, const DraggableDouble& d)
  {
    o << setw(15) << setprecision(12) << d.dbl;
    return o;
  }
};

#endif
