
#include <Xm/Xm.h>
#include <Xm/CascadeB.h>
#include <Xm/CascadeBG.h>
#include <Xm/Form.h>
#include <Xm/MainW.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
#include <Xm/Separator.h>
#include <Xm/Text.h>

#include <Xdt/QkHelp.h>

void _popupMenuEH(
   Widget w,
   XtPointer cd,
   XEvent* event,
   Boolean* ignore )
{
   Widget menu = (Widget) cd;
   
   if (event->type != ButtonPress) return;
   
   if (event->xbutton.button == Button3)
   {
      XmMenuPosition( menu, &event->xbutton );
      XtManageChild( menu );
   }
}

int main( argc, argv )
   int    argc;
   char** argv;
{
   XtAppContext app_context;
   Widget       toplevel;
   Widget       mainwindow, workarea, text, menubar, fileCB, editCBG;
   Widget       menu, btn, hint;
   XmString     cs;
   Cardinal	i;
   Arg		args[ 20 ];
   
   toplevel = XtAppInitialize( 
      &app_context, 
      "XDtText", 
      NULL,	0,
      &argc,	argv,
      NULL, 
      NULL, (Cardinal)0 );

   i = 0;
   mainwindow = XmCreateMainWindow( toplevel, "main", args, i );
   XtManageChild( mainwindow );
   
   i = 0;
   workarea = XmCreateForm( mainwindow, "workArea", args, i );   
   XtManageChild( workarea );
   
   i = 0;
   XtSetArg( args[ i ], XmNcolumns, 		80 );	i++;
   XtSetArg( args[ i ], XmNrows, 		40 );	i++;
   XtSetArg( args[ i ], XmNeditMode, 		XmMULTI_LINE_EDIT );	i++;
   XtSetArg( args[ i ], XmNleftAttachment, 	XmATTACH_FORM );	i++;
   XtSetArg( args[ i ], XmNrightAttachment, 	XmATTACH_FORM );	i++;
   XtSetArg( args[ i ], XmNtopAttachment, 	XmATTACH_FORM );	i++;
   XtSetArg( args[ i ], XmNbottomAttachment, 	XmATTACH_FORM );	i++;
   XtSetArg( args[ i ], XmNleftOffset, 		2 );	i++;
   XtSetArg( args[ i ], XmNrightOffset, 	2 );	i++;
   XtSetArg( args[ i ], XmNtopOffset, 		2 );	i++;
   XtSetArg( args[ i ], XmNbottomOffset, 	30 );	i++;
   text = XmCreateScrolledText( workarea, "text", args, i );   
   XtManageChild( text );

   i = 0;
   menubar = XmCreateMenuBar( mainwindow, "menubar", args, i ); 
   XtManageChild( menubar );

   /*
    * FILE MENU  -- Made of Widgets
    */
   i = 0;
   menu = XmCreatePulldownMenu( menubar, "fileMenu", args, i );

   i = 0;
   cs = XmStringCreateLocalized( "New" );
   XtSetArg( args[ i ], XmNlabelString, cs );	i++;
   btn = XmCreatePushButton( menu, "new", args, i );
   XmStringFree( cs );
   XtManageChild( btn );

   i = 0;
   cs = XmStringCreateLocalized( "Open..." );
   XtSetArg( args[ i ], XmNlabelString, cs );	i++;
   btn = XmCreatePushButton( menu, "open", args, i );
   XmStringFree( cs );
   XtManageChild( btn );

   i = 0;
   cs = XmStringCreateLocalized( "Save" );
   XtSetArg( args[ i ], XmNlabelString, cs );	i++;
   btn = XmCreatePushButton( menu, "save", args, i );
   XmStringFree( cs );
   XtManageChild( btn );

   i = 0;
   cs = XmStringCreateLocalized( "Save As..." );
   XtSetArg( args[ i ], XmNlabelString, cs );	i++;
   btn = XmCreatePushButton( menu, "saveAs", args, i );
   XmStringFree( cs );
   XtManageChild( btn );
   
   i = 0;
   cs = XmStringCreateLocalized( "Exit" );
   XtSetArg( args[ i ], XmNlabelString, cs );	i++;
   btn = XmCreatePushButton( menu, "exit", args, i );
   XmStringFree( cs );
   XtManageChild( btn );
   
   i = 0;
   cs = XmStringCreateLocalized( "File" );
   XtSetArg( args[ i ], XmNlabelString, cs );	i++;
   XtSetArg( args[ i ], XmNsubMenuId, menu );	i++;
   fileCB = XmCreateCascadeButton( menubar, "fileBtn", args, i ); 
   XmStringFree( cs );
   XtManageChild( fileCB );

   /*
    * EDIT MENU -- Made of gadgets
    */
   i = 0;
   menu = XmCreatePulldownMenu( menubar, "editMenu", args, i );

   i = 0;
   cs = XmStringCreateLocalized( "Cut" );
   XtSetArg( args[ i ], XmNlabelString, cs );	i++;
   btn = XmCreatePushButtonGadget( menu, "cut", args, i );
   XmStringFree( cs );
   XtManageChild( btn );

   i = 0;
   cs = XmStringCreateLocalized( "Copy" );
   XtSetArg( args[ i ], XmNlabelString, cs );	i++;
   btn = XmCreatePushButtonGadget( menu, "copy", args, i );
   XmStringFree( cs );
   XtManageChild( btn );

   i = 0;
   cs = XmStringCreateLocalized( "Paste" );
   XtSetArg( args[ i ], XmNlabelString, cs );	i++;
   btn = XmCreatePushButtonGadget( menu, "paste", args, i );
   XmStringFree( cs );
   XtManageChild( btn );

   i = 0;
   cs = XmStringCreateLocalized( "Edit" );
   XtSetArg( args[ i ], XmNlabelString, cs );	i++;
   XtSetArg( args[ i ], XmNsubMenuId, menu );	i++;
   editCBG = XmCreateCascadeButtonGadget( menubar, "editBtn", args, i ); 
   XmStringFree( cs );
   XtManageChild( editCBG );


   /*
    * POPUP MENU
    */
   i = 0;
   menu = XmCreatePopupMenu( text, "popupMenu", args, i );

   i = 0;
   cs = XmStringCreateLocalized( "Cut (Widget)" );
   XtSetArg( args[ i ], XmNlabelString, cs );	i++;
   btn = XmCreatePushButton( menu, "cut", args, i );
   XmStringFree( cs );
   XtManageChild( btn );

   i = 0;
   cs = XmStringCreateLocalized( "Copy (Widget)" );
   XtSetArg( args[ i ], XmNlabelString, cs );	i++;
   btn = XmCreatePushButton( menu, "copy", args, i );
   XmStringFree( cs );
   XtManageChild( btn );

   i = 0;
   cs = XmStringCreateLocalized( "Paste (Gadget)" );
   XtSetArg( args[ i ], XmNlabelString, cs );	i++;
   btn = XmCreatePushButtonGadget( menu, "paste", args, i );
   XmStringFree( cs );
   XtManageChild( btn );

   i = 0;
   XtSetArg( args[ i ], XmNorientation, XmHORIZONTAL );	i++;
   btn = XmCreateSeparator( menu, "sep", args, i );
   XtManageChild( btn );

   i = 0;
   cs = XmStringCreateLocalized( "New (Gadget)" );
   XtSetArg( args[ i ], XmNlabelString, cs );	i++;
   btn = XmCreatePushButtonGadget( menu, "new", args, i );
   XmStringFree( cs );
   XtManageChild( btn );

   i = 0;
   cs = XmStringCreateLocalized( "Open... (Widget)" );
   XtSetArg( args[ i ], XmNlabelString, cs );	i++;
   btn = XmCreatePushButton( menu, "open", args, i );
   XmStringFree( cs );
   XtManageChild( btn );

   i = 0;
   cs = XmStringCreateLocalized( "Save (Gadget)" );
   XtSetArg( args[ i ], XmNlabelString, cs );	i++;
   btn = XmCreatePushButtonGadget( menu, "save", args, i );
   XmStringFree( cs );
   XtManageChild( btn );

   i = 0;
   cs = XmStringCreateLocalized( "Save As... (Widget)" );
   XtSetArg( args[ i ], XmNlabelString, cs );	i++;
   btn = XmCreatePushButton( menu, "saveAs", args, i );
   XmStringFree( cs );
   XtManageChild( btn );

   XtAddEventHandler( text, ButtonPressMask, False, _popupMenuEH, menu );

   XdtQkHelpInstallOnShell( workarea, &hint );
   
   XtVaSetValues( 
      XtParent( text ), 
      XmNbottomAttachment,	XmATTACH_WIDGET,
      XmNbottomWidget,		hint,
      XmNbottomOffset,		5,
      NULL );
      
   XtVaSetValues(
      hint,
      XmNleftAttachment, 	XmATTACH_FORM,
      XmNrightAttachment, 	XmATTACH_FORM,
      XmNbottomAttachment, 	XmATTACH_FORM,
      XmNleftOffset, 		5,
      XmNrightOffset, 		5,
      XmNbottomOffset, 		2,
      NULL );
      
   XtRealizeWidget( toplevel );
   
   XtAppMainLoop( app_context );
}
