/* 
 * X Development Tools Library
 * $Id: Child.c,v 1.1 1996/04/01 03:48:28 rwerne Exp rwerne $
 * 
 * Written by Robert Werner.
 * Copyright (c) 1995, 1996 by Software Komponents International.
 * All Rights Reserved.  See the file COPYRIGHT for details.
 * This is not public domain software.  See the file LICENSE for details.
 * There is no warranty for this software.  See NO_WARRANTY for details.
 */

#include <X11/IntrinsicP.h>
#include <X11/CompositeP.h>	/* To get access to the Composite internals */

#include <Xdt/Child.h>

/*----------------------------------------------------------------------------*/

#if NeedFunctionPrototypes
Widget XdtGetDescendantAtPos(
   Widget w,
   int    x,
   int    y )
#else
Widget XdtGetDescendantAtPos( w, x, y )
   Widget w;
   int    x;
   int    y;
#endif
{
   Widget descendant = NULL;
   Widget next_child = NULL;
   
   if ((x >= 0) && (x < w->core.width ) &&
       (y >= 0) && (y < w->core.height))
   {
      descendant = w;
   
      do
      {
	 next_child = XdtGetWidgetChild( descendant, x, y );
	 if (!next_child)
	 {
            next_child = XdtGetGadgetChild( descendant, x, y );
	 }

	 if (next_child)
	 {
            descendant = next_child;
            x -= descendant->core.x;
            y -= descendant->core.y;
	 }
      }
      while (next_child);
   }
   
   return descendant;
}

/*----------------------------------------------------------------------------*/

#if NeedFunctionPrototypes
Widget XdtGetGadgetChild(
   Widget w,
   int    x,
   int    y )
#else
Widget XdtGetGadgetChild( w, x, y )
   Widget w;
   int    x;
   int    y;
#endif
{
   Widget gadget = NULL;
   
   if (XtIsComposite( w ))
   {
      CompositeWidget mgr = (CompositeWidget) w;
      int             i;

      for (i = mgr->composite.num_children - 1; i >= 0; i--)
      {
	 Widget child = mgr->composite.children[ i ];

	 if (child)
	 {
            if (!XtIsWidget( child ))
            {
               if (XtIsRectObj( child ))
               {
        	  if (XtIsManaged( child ))
        	  {
                     if ((x >= child->core.x                     ) && 
                	 (x <  child->core.x + child->core.width ) &&
                	 (y >= child->core.y                     ) &&
                	 (y <  child->core.y + child->core.height))
                     {
                	gadget = child;
                     }
        	  }
               }
            }
	 }	 
      }
   }
   return gadget;
}
/*----------------------------------------------------------------------------*/

#if NeedFunctionPrototypes
Widget XdtGetWidgetChild(
   Widget w,
   int    x,
   int    y )
#else
Widget XdtGetWidgetChild( w, x, y )
   Widget w;
   int    x;
   int    y;
#endif
{
   Widget widget = NULL;
   
   if (XtIsComposite( w ))
   {
      CompositeWidget mgr = (CompositeWidget) w;
      int             i;
   
      for (i = 0; i < mgr->composite.num_children; i++)
      {
	 Widget child = mgr->composite.children[ i ];

	 if (child)
	 {
            if (XtIsWidget( child ))
            {
               if (XtIsManaged( child ))
               {
                  if ((x >= child->core.x                     ) && 
                      (x <  child->core.x + child->core.width ) &&
                      (y >= child->core.y                     ) &&
                      (y <  child->core.y + child->core.height))
                  {
                     widget = child;
                  }
               }
            }
	 }
      }
   }
   return widget;
}
