#ifndef INCL_MENU_H
#define INCL_MENU_H

// *-----------------------------------------------------------------------
// * Xclasses class header file
// * 
// * class name: menu
// * author    : Jrgen Schmitz
// * version   : 1.0
// *-----------------------------------------------------------------------

#include <Xclasses/types.h>
#include <Xclasses/Ddraw.h>
#include <Xclasses/Xcolors.h>
#include <Xclasses/gadget.h>

#define REASON_INOTHERMENU	1	// proof: menu*
#define REASON_SUBWINDOW	2	// proof: Xwindows* with TransientFor()
#define REASON_SUID			3	// proof: NULL, getuid()!=geteuid()

class menu : Ddraw, public gadget
{
	friend class pmenu;
	
	class pmenu *p;

public:
    virtual void GExpose(XEvent *event);
    virtual void GActionPress(int mx,int my,int rx,int ry,unsigned int state,int button,int reason);
    virtual void GActionRelease(int mx,int my,int rx,int ry,unsigned int state,int button,int reason);
	virtual void GSetLimits(void);
	virtual int GActivate(XEvent *event,int why);
	virtual int GSelected(XEvent *event,int why,int wasabove);
    virtual int GMouseMove(int mx,int my,int rx,int ry,unsigned int state,int button);

    menu();
    virtual ~menu();

	int Create();
	void Free(void);

	void Resize(int w,int h);
	void Lock(void);
	void Unlock(void);
    void Block(int);
    void Unblock(int);

	void LockItem(int menu,int id);
	void UnlockItem(int menu,int id);
	void LockHeadOf(int menu,int id);
	void UnlockHeadOf(int menu,int id);

	void State(int menu,int id,int state);
	int State(int menu,int id);

	void Selected(int menu,int id,int s);
	int Selected(int menu,int id);

	void AddMenu(char *);
	void AddHelpMenu(char *);
	void Add(char *text,char *scut,int id);
	void Add(char *text,int id) { Add(text,NULL,id); };
	void AddRuler(void);
	void AddHeadline(char *);
	void AddSel(char *text,char *scut,int id);
	void AddSel(char *text,int id) { AddSel(text,NULL,id); };
	void AddMX(char **text,char **scut,int id);
	void AddMX(char **text,int id) { AddMX(text,NULL,id); };
	void AddSub(char *text);
	void EndSub(void);
	void NoHelpMenu(int reason,void *proof);

	void Clear(void);
	void Recreate(void);

	int Menu(void);
	int MID(void);
	unsigned int Selection(void);	// bits 0-23: ID, 24-31: menu
};

#endif
